/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.upgrades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.api.upgrades.IUpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.internal.upgrades.SerialiserWithCraftingItem;
import dan200.computercraft.internal.upgrades.SimpleSerialiser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class UpgradeDataProvider<T extends IUpgradeBase, R extends UpgradeSerialiser<?, R>>
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String name;
    private final String folder;
    private final ResourceKey<Registry<R>> registry;
    private List<T> upgrades;

    protected UpgradeDataProvider(@Nonnull DataGenerator generator, @Nonnull String name, @Nonnull String folder, @Nonnull ResourceKey<Registry<R>> registry) {
        this.generator = generator;
        this.name = name;
        this.folder = folder;
        this.registry = registry;
    }

    @Nonnull
    public final Upgrade<R> simple(@Nonnull ResourceLocation id, @Nonnull R serialiser) {
        if (!(serialiser instanceof SimpleSerialiser)) {
            throw new IllegalStateException(serialiser + " must be a simple() seriaiser.");
        }
        return new Upgrade<R>(id, serialiser, s -> {});
    }

    @Nonnull
    public final Upgrade<R> simpleWithCustomItem(@Nonnull ResourceLocation id, @Nonnull R serialiser, @Nonnull Item item) {
        if (!(serialiser instanceof SerialiserWithCraftingItem)) {
            throw new IllegalStateException(serialiser + " must be a simpleWithCustomItem() serialiser.");
        }
        return new Upgrade<R>(id, serialiser, s -> s.addProperty("item", Objects.requireNonNull(item.getRegistryName(), "Item is not registered").toString()));
    }

    protected abstract void addUpgrades(@Nonnull Consumer<Upgrade<R>> var1);

    public final void m_6865_(@Nonnull HashCache cache) throws IOException {
        Path base = this.generator.m_123916_().resolve("data");
        HashSet seen = new HashSet();
        ArrayList<T> upgrades = new ArrayList<T>();
        this.addUpgrades(upgrade -> {
            if (!seen.add(upgrade.id())) {
                throw new IllegalStateException("Duplicate upgrade " + upgrade.id());
            }
            JsonObject json = new JsonObject();
            json.addProperty("type", Objects.requireNonNull(upgrade.serialiser().getRegistryName(), "Serialiser has not been registered").toString());
            upgrade.serialise().accept(json);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)json, (Path)base.resolve(upgrade.id().m_135827_() + "/" + this.folder + "/" + upgrade.id().m_135815_() + ".json"));
            }
            catch (IOException e) {
                LOGGER.error("Failed to save {} {}", (Object)this.name, (Object)upgrade.id(), (Object)e);
            }
            try {
                Object result = upgrade.serialiser().fromJson(upgrade.id(), json);
                upgrades.add(result);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Failed to parse {} {}", (Object)this.name, (Object)upgrade.id(), (Object)e);
            }
        });
        this.upgrades = upgrades;
    }

    @Nonnull
    public final String m_6055_() {
        return this.name;
    }

    @Nonnull
    public final R existingSerialiser(@Nonnull ResourceLocation id) {
        UpgradeSerialiser result = (UpgradeSerialiser)RegistryManager.ACTIVE.getRegistry(this.registry).getValue(id);
        if (result == null) {
            throw new IllegalArgumentException("No such serialiser " + this.registry);
        }
        return (R)result;
    }

    @Nonnull
    public List<T> getGeneratedUpgrades() {
        if (this.upgrades == null) {
            throw new IllegalStateException("Upgrades have not beeen generated yet");
        }
        return this.upgrades;
    }

    public record Upgrade<R extends UpgradeSerialiser<?, R>>(ResourceLocation id, R serialiser, Consumer<JsonObject> serialise) {
        public void add(@Nonnull Consumer<Upgrade<R>> add) {
            add.accept(this);
        }
    }
}

