/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import com.google.common.base.Objects;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.websocket.Websocket;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.util.StringUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;

public class WebsocketHandle
implements Closeable {
    private final Websocket websocket;
    private final Options options;
    private boolean closed = false;
    private Channel channel;

    public WebsocketHandle(Websocket websocket, Options options, Channel channel) {
        this.websocket = websocket;
        this.options = options;
        this.channel = channel;
    }

    @LuaFunction
    public final MethodResult receive(Optional<Double> timeout) throws LuaException {
        this.checkOpen();
        int timeoutId = timeout.isPresent() ? this.websocket.environment().startTimer(Math.round(LuaValues.checkFinite(0, timeout.get()) / 0.05)) : -1;
        return (WebsocketHandle)this.new ReceiveCallback((int)timeoutId).pull;
    }

    @LuaFunction
    public final void send(Object message, Optional<Boolean> binary) throws LuaException {
        this.checkOpen();
        String text = StringUtil.toString(message);
        if (this.options.websocketMessage != 0 && text.length() > this.options.websocketMessage) {
            throw new LuaException("Message is too large");
        }
        this.websocket.environment().observe(Metrics.WEBSOCKET_OUTGOING, text.length());
        Channel channel = this.channel;
        if (channel != null) {
            channel.writeAndFlush(binary.orElse(false) != false ? new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)LuaValues.encode(text))) : new TextWebSocketFrame(text));
        }
    }

    @LuaFunction(value={"close"})
    public final void doClose() {
        this.close();
        this.websocket.close();
    }

    private void checkOpen() throws LuaException {
        if (this.closed) {
            throw new LuaException("attempt to use a closed file");
        }
    }

    @Override
    public void close() {
        this.closed = true;
        Channel channel = this.channel;
        if (channel != null) {
            channel.close();
            this.channel = null;
        }
    }

    private final class ReceiveCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent(null, this);
        private final int timeoutId;

        ReceiveCallback(int timeoutId) {
            this.timeoutId = timeoutId;
        }

        @Override
        @Nonnull
        public MethodResult resume(Object[] event) {
            Number id;
            Object object;
            if (event.length >= 3 && Objects.equal((Object)event[0], (Object)"websocket_message") && Objects.equal((Object)event[1], (Object)WebsocketHandle.this.websocket.address())) {
                return MethodResult.of(Arrays.copyOfRange(event, 2, event.length));
            }
            if (event.length >= 2 && Objects.equal((Object)event[0], (Object)"websocket_closed") && Objects.equal((Object)event[1], (Object)WebsocketHandle.this.websocket.address()) && WebsocketHandle.this.closed) {
                return MethodResult.of();
            }
            if (event.length >= 2 && this.timeoutId != -1 && Objects.equal((Object)event[0], (Object)"timer") && (object = event[1]) instanceof Number && (id = (Number)object).intValue() == this.timeoutId) {
                return MethodResult.of();
            }
            return this.pull;
        }
    }
}

