/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.computer.menu.ServerInputHandler;
import dan200.computercraft.shared.computer.menu.ServerInputState;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;

public abstract class ContainerComputerBase
extends AbstractContainerMenu
implements ComputerMenu {
    private final Predicate<Player> canUse;
    private final ComputerFamily family;
    private final ContainerData data;
    @Nullable
    private final ServerComputer computer;
    @Nullable
    private final ServerInputState<ContainerComputerBase> input;
    @Nullable
    private final NetworkedTerminal terminal;
    private final ItemStack displayStack;

    public ContainerComputerBase(MenuType<? extends ContainerComputerBase> type, int id, Predicate<Player> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData containerData) {
        super(type, id);
        this.canUse = canUse;
        this.family = family;
        this.data = computer == null ? new SimpleContainerData(1) : () -> computer.isOn() ? 1 : 0;
        this.m_38884_(this.data);
        this.computer = computer;
        this.input = computer == null ? null : new ServerInputState<ContainerComputerBase>(this);
        this.terminal = containerData == null ? null : containerData.terminal().create();
        this.displayStack = containerData == null ? null : containerData.displayStack();
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.canUse.test(player);
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    public boolean isOn() {
        return this.data.m_6413_(0) != 0;
    }

    @Override
    public ServerComputer getComputer() {
        if (this.computer == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.computer;
    }

    @Override
    public ServerInputHandler getInput() {
        if (this.input == null) {
            throw new UnsupportedOperationException("Cannot access server computer on the client");
        }
        return this.input;
    }

    @Override
    public void updateTerminal(TerminalState state) {
        if (this.terminal == null) {
            throw new UnsupportedOperationException("Cannot update terminal on the server");
        }
        state.apply(this.terminal);
    }

    public Terminal getTerminal() {
        if (this.terminal == null) {
            throw new IllegalStateException("Cannot update terminal on the server");
        }
        return this.terminal;
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        if (this.input != null) {
            this.input.close();
        }
    }

    @Nonnull
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }
}

