/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Objects;
import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleCommandQueueEntry;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TurtleBrain
implements ITurtleAccess {
    public static final String NBT_RIGHT_UPGRADE = "RightUpgrade";
    public static final String NBT_RIGHT_UPGRADE_DATA = "RightUpgradeNbt";
    public static final String NBT_LEFT_UPGRADE = "LeftUpgrade";
    public static final String NBT_LEFT_UPGRADE_DATA = "LeftUpgradeNbt";
    public static final String NBT_FUEL = "Fuel";
    public static final String NBT_OVERLAY = "Overlay";
    private static final String NBT_SLOT = "Slot";
    private static final int ANIM_DURATION = 8;
    public static final Predicate<Entity> PUSHABLE_ENTITY = entity -> !entity.m_5833_() && entity.m_7752_() != PushReaction.IGNORE;
    private TileTurtle owner;
    private ComputerProxy proxy;
    private GameProfile owningPlayer;
    private final Container inventory = () -> this.owner;
    private final IItemHandlerModifiable inventoryWrapper = new InvWrapper(this.inventory);
    private final Queue<TurtleCommandQueueEntry> commandQueue = new ArrayDeque<TurtleCommandQueueEntry>();
    private int commandsIssued = 0;
    private final Map<TurtleSide, ITurtleUpgrade> upgrades = new EnumMap<TurtleSide, ITurtleUpgrade>(TurtleSide.class);
    private final Map<TurtleSide, IPeripheral> peripherals = new EnumMap<TurtleSide, IPeripheral>(TurtleSide.class);
    private final Map<TurtleSide, CompoundTag> upgradeNBTData = new EnumMap<TurtleSide, CompoundTag>(TurtleSide.class);
    private int selectedSlot = 0;
    private int fuelLevel = 0;
    private int colourHex = -1;
    private ResourceLocation overlay = null;
    private TurtleAnimation animation = TurtleAnimation.NONE;
    private int animationProgress = 0;
    private int lastAnimationProgress = 0;
    TurtlePlayer cachedPlayer;

    public TurtleBrain(TileTurtle turtle) {
        this.owner = turtle;
    }

    public void setOwner(TileTurtle owner) {
        this.owner = owner;
    }

    public TileTurtle getOwner() {
        return this.owner;
    }

    public ComputerProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new ComputerProxy(() -> this.owner);
        }
        return this.proxy;
    }

    public ComputerFamily getFamily() {
        return this.owner.getFamily();
    }

    public void setupComputer(ServerComputer computer) {
        this.updatePeripherals(computer);
    }

    public void update() {
        Level world = this.getLevel();
        if (!world.f_46443_) {
            this.updateCommands();
            if (this.owner.m_58901_()) {
                return;
            }
        }
        this.updateAnimation();
        if (!this.upgrades.isEmpty()) {
            for (Map.Entry<TurtleSide, ITurtleUpgrade> entry : this.upgrades.entrySet()) {
                entry.getValue().update(this, entry.getKey());
            }
        }
    }

    private void readCommon(CompoundTag nbt) {
        this.colourHex = nbt.m_128441_("Color") ? nbt.m_128451_("Color") : -1;
        this.fuelLevel = nbt.m_128441_(NBT_FUEL) ? nbt.m_128451_(NBT_FUEL) : 0;
        this.overlay = nbt.m_128441_(NBT_OVERLAY) ? new ResourceLocation(nbt.m_128461_(NBT_OVERLAY)) : null;
        this.setUpgradeDirect(TurtleSide.LEFT, nbt.m_128441_(NBT_LEFT_UPGRADE) ? TurtleUpgrades.instance().get(nbt.m_128461_(NBT_LEFT_UPGRADE)) : null);
        this.setUpgradeDirect(TurtleSide.RIGHT, nbt.m_128441_(NBT_RIGHT_UPGRADE) ? TurtleUpgrades.instance().get(nbt.m_128461_(NBT_RIGHT_UPGRADE)) : null);
        this.upgradeNBTData.clear();
        if (nbt.m_128441_(NBT_LEFT_UPGRADE_DATA)) {
            this.upgradeNBTData.put(TurtleSide.LEFT, nbt.m_128469_(NBT_LEFT_UPGRADE_DATA).m_6426_());
        }
        if (nbt.m_128441_(NBT_RIGHT_UPGRADE_DATA)) {
            this.upgradeNBTData.put(TurtleSide.RIGHT, nbt.m_128469_(NBT_RIGHT_UPGRADE_DATA).m_6426_());
        }
    }

    private void writeCommon(CompoundTag nbt) {
        String rightUpgradeId;
        String leftUpgradeId;
        nbt.m_128405_(NBT_FUEL, this.fuelLevel);
        if (this.colourHex != -1) {
            nbt.m_128405_("Color", this.colourHex);
        }
        if (this.overlay != null) {
            nbt.m_128359_(NBT_OVERLAY, this.overlay.toString());
        }
        if ((leftUpgradeId = TurtleBrain.getUpgradeId(this.getUpgrade(TurtleSide.LEFT))) != null) {
            nbt.m_128359_(NBT_LEFT_UPGRADE, leftUpgradeId);
        }
        if ((rightUpgradeId = TurtleBrain.getUpgradeId(this.getUpgrade(TurtleSide.RIGHT))) != null) {
            nbt.m_128359_(NBT_RIGHT_UPGRADE, rightUpgradeId);
        }
        if (this.upgradeNBTData.containsKey((Object)TurtleSide.LEFT)) {
            nbt.m_128365_(NBT_LEFT_UPGRADE_DATA, (Tag)this.getUpgradeNBTData(TurtleSide.LEFT).m_6426_());
        }
        if (this.upgradeNBTData.containsKey((Object)TurtleSide.RIGHT)) {
            nbt.m_128365_(NBT_RIGHT_UPGRADE_DATA, (Tag)this.getUpgradeNBTData(TurtleSide.RIGHT).m_6426_());
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        this.readCommon(nbt);
        this.selectedSlot = nbt.m_128451_(NBT_SLOT);
        if (nbt.m_128425_("Owner", 10)) {
            CompoundTag owner = nbt.m_128469_("Owner");
            this.owningPlayer = new GameProfile(new UUID(owner.m_128454_("UpperId"), owner.m_128454_("LowerId")), owner.m_128461_("Name"));
        } else {
            this.owningPlayer = null;
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.writeCommon(nbt);
        nbt.m_128405_(NBT_SLOT, this.selectedSlot);
        if (this.owningPlayer != null) {
            CompoundTag owner = new CompoundTag();
            nbt.m_128365_("Owner", (Tag)owner);
            owner.m_128356_("UpperId", this.owningPlayer.getId().getMostSignificantBits());
            owner.m_128356_("LowerId", this.owningPlayer.getId().getLeastSignificantBits());
            owner.m_128359_("Name", this.owningPlayer.getName());
        }
        return nbt;
    }

    private static String getUpgradeId(ITurtleUpgrade upgrade) {
        return upgrade != null ? upgrade.getUpgradeID().toString() : null;
    }

    public void readDescription(CompoundTag nbt) {
        this.readCommon(nbt);
        TurtleAnimation anim = TurtleAnimation.values()[nbt.m_128451_("Animation")];
        if (anim != this.animation && anim != TurtleAnimation.WAIT && anim != TurtleAnimation.SHORT_WAIT && anim != TurtleAnimation.NONE) {
            this.animation = anim;
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
    }

    public void writeDescription(CompoundTag nbt) {
        this.writeCommon(nbt);
        nbt.m_128405_("Animation", this.animation.ordinal());
    }

    @Override
    @Nonnull
    public Level getLevel() {
        return this.owner.m_58904_();
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return this.owner.m_58899_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean teleportTo(@Nonnull Level world, @Nonnull BlockPos pos) {
        if (world.f_46443_ || this.getLevel().f_46443_) {
            throw new UnsupportedOperationException("Cannot teleport on the client");
        }
        Level oldWorld = this.getLevel();
        TileTurtle oldOwner = this.owner;
        BlockPos oldPos = this.owner.m_58899_();
        BlockState oldBlock = this.owner.m_58900_();
        if (oldWorld == world && oldPos.equals((Object)pos)) {
            return true;
        }
        if (!world.m_46749_(pos)) {
            return false;
        }
        if (!world.m_6857_().m_61937_(pos)) {
            return false;
        }
        FluidState existingFluid = world.m_8055_(pos).m_60819_();
        BlockState newState = (BlockState)oldBlock.m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(existingFluid.m_205070_(FluidTags.f_13131_) && existingFluid.m_76170_()));
        oldOwner.notifyMoveStart();
        try {
            if (world.m_7731_(pos, newState, 2)) {
                BlockEntity newTile;
                Block block = world.m_8055_(pos).m_60734_();
                if (block == oldBlock.m_60734_() && (newTile = world.m_7702_(pos)) instanceof TileTurtle) {
                    TileTurtle newTurtle = (TileTurtle)newTile;
                    newTurtle.m_142339_(world);
                    newTurtle.transferStateFrom(oldOwner);
                    ServerComputer computer = newTurtle.createServerComputer();
                    computer.setLevel((ServerLevel)world);
                    computer.setPosition(pos);
                    oldWorld.m_7471_(oldPos, false);
                    newTurtle.updateOutput();
                    newTurtle.updateInputsImmediately();
                    boolean bl = true;
                    return bl;
                }
                world.m_7471_(pos, false);
            }
        }
        finally {
            oldOwner.notifyMoveEnd();
        }
        return false;
    }

    @Override
    @Nonnull
    public Vec3 getVisualPosition(float f) {
        Vec3 offset = this.getRenderOffset(f);
        BlockPos pos = this.owner.m_58899_();
        return new Vec3((double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + 0.5 + offset.f_82480_, (double)pos.m_123343_() + 0.5 + offset.f_82481_);
    }

    @Override
    public float getVisualYaw(float f) {
        float yaw = this.getDirection().m_122435_();
        switch (this.animation) {
            case TURN_LEFT: {
                yaw += 90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw >= 360.0f)) break;
                yaw -= 360.0f;
                break;
            }
            case TURN_RIGHT: {
                yaw += -90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw < 0.0f)) break;
                yaw += 360.0f;
            }
        }
        return yaw;
    }

    @Override
    @Nonnull
    public Direction getDirection() {
        return this.owner.getDirection();
    }

    @Override
    public void setDirection(@Nonnull Direction dir) {
        this.owner.setDirection(dir);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        if (this.getLevel().f_46443_) {
            throw new UnsupportedOperationException("Cannot set the slot on the client");
        }
        if (slot >= 0 && slot < this.owner.m_6643_()) {
            this.selectedSlot = slot;
            this.owner.onTileEntityChange();
        }
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public IItemHandlerModifiable getItemHandler() {
        return this.inventoryWrapper;
    }

    @Override
    public boolean isFuelNeeded() {
        return ComputerCraft.turtlesNeedFuel;
    }

    @Override
    public int getFuelLevel() {
        return Math.min(this.fuelLevel, this.getFuelLimit());
    }

    @Override
    public void setFuelLevel(int level) {
        this.fuelLevel = Math.min(level, this.getFuelLimit());
        this.owner.onTileEntityChange();
    }

    @Override
    public int getFuelLimit() {
        if (this.owner.getFamily() == ComputerFamily.ADVANCED) {
            return ComputerCraft.advancedTurtleFuelLimit;
        }
        return ComputerCraft.turtleFuelLimit;
    }

    @Override
    public boolean consumeFuel(int fuel) {
        if (this.getLevel().f_46443_) {
            throw new UnsupportedOperationException("Cannot consume fuel on the client");
        }
        if (!this.isFuelNeeded()) {
            return true;
        }
        int consumption = Math.max(fuel, 0);
        if (this.getFuelLevel() >= consumption) {
            this.setFuelLevel(this.getFuelLevel() - consumption);
            return true;
        }
        return false;
    }

    @Override
    public void addFuel(int fuel) {
        if (this.getLevel().f_46443_) {
            throw new UnsupportedOperationException("Cannot add fuel on the client");
        }
        int addition = Math.max(fuel, 0);
        this.setFuelLevel(this.getFuelLevel() + addition);
    }

    @Override
    @Nonnull
    public MethodResult executeCommand(@Nonnull ITurtleCommand command) {
        if (this.getLevel().f_46443_) {
            throw new UnsupportedOperationException("Cannot run commands on the client");
        }
        if (this.commandQueue.size() > 16) {
            return MethodResult.of(false, "Too many ongoing turtle commands");
        }
        this.commandQueue.offer(new TurtleCommandQueueEntry(++this.commandsIssued, command));
        int commandID = this.commandsIssued;
        return new CommandCallback((int)commandID).pull;
    }

    @Override
    public void playAnimation(@Nonnull TurtleAnimation animation) {
        if (this.getLevel().f_46443_) {
            throw new UnsupportedOperationException("Cannot play animations on the client");
        }
        this.animation = animation;
        if (this.animation == TurtleAnimation.SHORT_WAIT) {
            this.animationProgress = 4;
            this.lastAnimationProgress = 4;
        } else {
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
        this.owner.updateBlock();
    }

    public ResourceLocation getOverlay() {
        return this.overlay;
    }

    public void setOverlay(ResourceLocation overlay) {
        if (!Objects.equal((Object)this.overlay, (Object)overlay)) {
            this.overlay = overlay;
            this.owner.updateBlock();
        }
    }

    public DyeColor getDyeColour() {
        if (this.colourHex == -1) {
            return null;
        }
        Colour colour = Colour.fromHex(this.colourHex);
        return colour == null ? null : DyeColor.m_41053_((int)(15 - colour.ordinal()));
    }

    public void setDyeColour(DyeColor dyeColour) {
        int newColour = -1;
        if (dyeColour != null) {
            newColour = Colour.values()[15 - dyeColour.m_41060_()].getHex();
        }
        if (this.colourHex != newColour) {
            this.colourHex = newColour;
            this.owner.updateBlock();
        }
    }

    @Override
    public void setColour(int colour) {
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (this.colourHex != colour) {
                this.colourHex = colour;
                this.owner.updateBlock();
            }
        } else if (this.colourHex != -1) {
            this.colourHex = -1;
            this.owner.updateBlock();
        }
    }

    @Override
    public int getColour() {
        return this.colourHex;
    }

    public void setOwningPlayer(GameProfile profile) {
        this.owningPlayer = profile;
    }

    @Override
    @Nullable
    public GameProfile getOwningPlayer() {
        return this.owningPlayer;
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull TurtleSide side) {
        return this.upgrades.get((Object)side);
    }

    @Override
    public void setUpgrade(@Nonnull TurtleSide side, ITurtleUpgrade upgrade) {
        if (!this.setUpgradeDirect(side, upgrade) || this.owner.m_58904_() == null) {
            return;
        }
        this.owner.updateBlock();
        this.owner.updateInputsImmediately();
    }

    private boolean setUpgradeDirect(@Nonnull TurtleSide side, ITurtleUpgrade upgrade) {
        if (this.upgrades.containsKey((Object)side)) {
            if (this.upgrades.get((Object)side) == upgrade) {
                return false;
            }
            this.upgrades.remove((Object)side);
        } else if (upgrade == null) {
            return false;
        }
        this.upgradeNBTData.remove((Object)side);
        if (upgrade != null) {
            this.upgrades.put(side, upgrade);
        }
        if (this.owner.m_58904_() != null && !this.owner.m_58904_().f_46443_) {
            this.updatePeripherals(this.owner.createServerComputer());
        }
        return true;
    }

    @Override
    public IPeripheral getPeripheral(@Nonnull TurtleSide side) {
        return this.peripherals.get((Object)side);
    }

    @Override
    @Nonnull
    public CompoundTag getUpgradeNBTData(TurtleSide side) {
        CompoundTag nbt = this.upgradeNBTData.get((Object)side);
        if (nbt == null) {
            nbt = new CompoundTag();
            this.upgradeNBTData.put(side, nbt);
        }
        return nbt;
    }

    @Override
    public void updateUpgradeNBTData(@Nonnull TurtleSide side) {
        this.owner.updateBlock();
    }

    public Vec3 getRenderOffset(float f) {
        switch (this.animation) {
            case MOVE_FORWARD: 
            case MOVE_BACK: 
            case MOVE_UP: 
            case MOVE_DOWN: {
                Direction dir = switch (this.animation) {
                    default -> this.getDirection();
                    case TurtleAnimation.MOVE_BACK -> this.getDirection().m_122424_();
                    case TurtleAnimation.MOVE_UP -> Direction.UP;
                    case TurtleAnimation.MOVE_DOWN -> Direction.DOWN;
                };
                double distance = -1.0 + (double)this.getAnimationFraction(f);
                return new Vec3(distance * (double)dir.m_122429_(), distance * (double)dir.m_122430_(), distance * (double)dir.m_122431_());
            }
        }
        return Vec3.f_82478_;
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return side == TurtleSide.LEFT && this.animation == TurtleAnimation.SWING_LEFT_TOOL || side == TurtleSide.RIGHT && this.animation == TurtleAnimation.SWING_RIGHT_TOOL ? 45.0f * (float)Math.sin((double)this.getAnimationFraction(f) * Math.PI) : 0.0f;
    }

    private static ComputerSide toDirection(TurtleSide side) {
        switch (side) {
            case LEFT: {
                return ComputerSide.LEFT;
            }
        }
        return ComputerSide.RIGHT;
    }

    private void updatePeripherals(ServerComputer serverComputer) {
        if (serverComputer == null) {
            return;
        }
        for (TurtleSide side : TurtleSide.values()) {
            IPeripheral existing;
            ITurtleUpgrade upgrade = this.getUpgrade(side);
            IPeripheral peripheral = null;
            if (upgrade != null && upgrade.getType().isPeripheral()) {
                peripheral = upgrade.createPeripheral(this, side);
            }
            if ((existing = this.peripherals.get((Object)side)) == peripheral || existing != null && peripheral != null && existing.equals(peripheral)) {
                peripheral = existing;
            } else {
                this.peripherals.put(side, peripheral);
            }
            serverComputer.setPeripheral(TurtleBrain.toDirection(side), peripheral);
        }
    }

    private void updateCommands() {
        if (this.animation != TurtleAnimation.NONE || this.commandQueue.isEmpty()) {
            return;
        }
        ServerComputer computer = this.owner.getServerComputer();
        if (computer != null && !computer.getComputer().getMainThreadMonitor().canWork()) {
            return;
        }
        TurtleCommandQueueEntry nextCommand = this.commandQueue.poll();
        if (nextCommand == null) {
            return;
        }
        long start = System.nanoTime();
        TurtleCommandResult result = nextCommand.command().execute(this);
        long end = System.nanoTime();
        if (computer == null) {
            return;
        }
        computer.getComputer().getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
        int callbackID = nextCommand.callbackID();
        if (callbackID < 0) {
            return;
        }
        if (result != null && result.isSuccess()) {
            Object[] results = result.getResults();
            if (results != null) {
                Object[] arguments = new Object[results.length + 2];
                arguments[0] = callbackID;
                arguments[1] = true;
                System.arraycopy(results, 0, arguments, 2, results.length);
                computer.queueEvent("turtle_response", arguments);
            } else {
                computer.queueEvent("turtle_response", new Object[]{callbackID, true});
            }
        } else {
            computer.queueEvent("turtle_response", new Object[]{callbackID, false, result != null ? result.getErrorMessage() : null});
        }
    }

    private void updateAnimation() {
        if (this.animation != TurtleAnimation.NONE) {
            Vec3 position;
            Holiday currentHoliday;
            Level world = this.getLevel();
            if (ComputerCraft.turtlesCanPush && (this.animation == TurtleAnimation.MOVE_FORWARD || this.animation == TurtleAnimation.MOVE_BACK || this.animation == TurtleAnimation.MOVE_UP || this.animation == TurtleAnimation.MOVE_DOWN)) {
                BlockPos pos = this.getPosition();
                Direction moveDir = switch (this.animation) {
                    default -> this.getDirection();
                    case TurtleAnimation.MOVE_BACK -> this.getDirection().m_122424_();
                    case TurtleAnimation.MOVE_UP -> Direction.UP;
                    case TurtleAnimation.MOVE_DOWN -> Direction.DOWN;
                };
                double minX = pos.m_123341_();
                double minY = pos.m_123342_();
                double minZ = pos.m_123343_();
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                float pushFrac = 1.0f - (float)(this.animationProgress + 1) / 8.0f;
                float push = Math.max(pushFrac + 0.0125f, 0.0f);
                if (moveDir.m_122429_() < 0) {
                    minX += (double)((float)moveDir.m_122429_() * push);
                } else {
                    maxX -= (double)((float)moveDir.m_122429_() * push);
                }
                if (moveDir.m_122430_() < 0) {
                    minY += (double)((float)moveDir.m_122430_() * push);
                } else {
                    maxY -= (double)((float)moveDir.m_122430_() * push);
                }
                if (moveDir.m_122431_() < 0) {
                    minZ += (double)((float)moveDir.m_122431_() * push);
                } else {
                    maxZ -= (double)((float)moveDir.m_122431_() * push);
                }
                AABB aabb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
                List list = world.m_6443_(Entity.class, aabb, PUSHABLE_ENTITY);
                if (!list.isEmpty()) {
                    double pushStep = 0.125;
                    double pushStepX = (double)moveDir.m_122429_() * pushStep;
                    double pushStepY = (double)moveDir.m_122430_() * pushStep;
                    double pushStepZ = (double)moveDir.m_122431_() * pushStep;
                    for (Entity entity : list) {
                        entity.m_6478_(MoverType.PISTON, new Vec3(pushStepX, pushStepY, pushStepZ));
                    }
                }
            }
            if (world.f_46443_ && this.animation == TurtleAnimation.MOVE_FORWARD && this.animationProgress == 4 && (currentHoliday = HolidayUtil.getCurrentHoliday()) == Holiday.VALENTINES && (position = this.getVisualPosition(1.0f)) != null) {
                double x = position.f_82479_ + world.f_46441_.nextGaussian() * 0.1;
                double y = position.f_82480_ + 0.5 + world.f_46441_.nextGaussian() * 0.1;
                double z = position.f_82481_ + world.f_46441_.nextGaussian() * 0.1;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, world.f_46441_.nextGaussian() * 0.02, world.f_46441_.nextGaussian() * 0.02, world.f_46441_.nextGaussian() * 0.02);
            }
            this.lastAnimationProgress = this.animationProgress++;
            if (this.animationProgress >= 8) {
                this.animation = TurtleAnimation.NONE;
                this.animationProgress = 0;
                this.lastAnimationProgress = 0;
            }
        }
    }

    private float getAnimationFraction(float f) {
        float next = (float)this.animationProgress / 8.0f;
        float previous = (float)this.lastAnimationProgress / 8.0f;
        return previous + (next - previous) * f;
    }

    private static final class CommandCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent("turtle_response", this);
        private final int command;

        CommandCallback(int command) {
            this.command = command;
        }

        @Override
        @Nonnull
        public MethodResult resume(Object[] response) {
            Number id;
            block5: {
                block4: {
                    Object object;
                    if (response.length < 3 || !((object = response[1]) instanceof Number)) break block4;
                    id = (Number)object;
                    if (response[2] instanceof Boolean) break block5;
                }
                return this.pull;
            }
            if (id.intValue() != this.command) {
                return this.pull;
            }
            return MethodResult.of(Arrays.copyOfRange(response, 2, response.length));
        }
    }
}

