/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public class TrampolineBlockEntity
extends BlockEntity {
    private int count = 1;
    private DyeColor colour = DyeColor.WHITE;

    public TrampolineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAMPOLINE.get(), pos, state);
    }

    protected TrampolineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onLoad() {
        BlockEntityUtil.sendUpdatePacket(this);
    }

    public void setCount(int count) {
        this.count = count;
        BlockEntityUtil.sendUpdatePacket(this);
    }

    public int getCount() {
        return this.count;
    }

    public DyeColor getColour() {
        return this.colour;
    }

    public void setColour(DyeColor colour) {
        this.colour = colour;
    }

    public void updateCount() {
        HashSet<TrampolineBlockEntity> trampolines = new HashSet<TrampolineBlockEntity>();
        this.isTrampoline(trampolines, this.f_58858_);
        trampolines.forEach(trampoline -> trampoline.setCount(trampolines.size()));
    }

    private void isTrampoline(Set<TrampolineBlockEntity> trampolines, BlockPos pos) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(pos);
        if (tileEntity instanceof TrampolineBlockEntity) {
            if (trampolines.contains(tileEntity)) {
                return;
            }
            trampolines.add((TrampolineBlockEntity)tileEntity);
            this.isTrampoline(trampolines, pos.m_142300_(Direction.NORTH));
            this.isTrampoline(trampolines, pos.m_142300_(Direction.EAST));
            this.isTrampoline(trampolines, pos.m_142300_(Direction.SOUTH));
            this.isTrampoline(trampolines, pos.m_142300_(Direction.WEST));
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readData(compound);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeData(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.readData(compound);
    }

    private void readData(CompoundTag compound) {
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
        if (compound.m_128425_("Color", 3)) {
            this.colour = DyeColor.m_41053_((int)compound.m_128451_("Color"));
        }
    }

    private CompoundTag writeData(CompoundTag compound) {
        compound.m_128405_("Count", this.count);
        compound.m_128405_("Color", this.colour.m_41060_());
        return compound;
    }

    @Nonnull
    public IModelData getModelData() {
        return super.getModelData();
    }
}

