/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.attachment;

import cofh.core.util.filter.BaseFluidFilter;
import cofh.core.util.filter.IFilter;
import cofh.lib.api.IConveyableData;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.attachment.IFilterableAttachment;
import cofh.thermal.dynamics.attachment.IRedstoneControllableAttachment;
import cofh.thermal.dynamics.attachment.RedstoneControlLogic;
import cofh.thermal.dynamics.client.TDynTextures;
import cofh.thermal.dynamics.inventory.container.attachment.FluidFilterAttachmentContainer;
import cofh.thermal.dynamics.network.packet.server.AttachmentConfigPacket;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidFilterAttachment
implements IFilterableAttachment,
IRedstoneControllableAttachment,
IConveyableData,
MenuProvider {
    public static final Component DISPLAY_NAME = new TranslatableComponent("attachment.thermal.filter");
    protected final IDuct<?, ?> duct;
    protected final Direction side;
    protected FilterMode mode = FilterMode.BIDIRECTIONAL;
    protected BaseFluidFilter filter = new BaseFluidFilter(15);
    protected RedstoneControlLogic rsControl = new RedstoneControlLogic(this);
    protected LazyOptional<IFluidHandler> gridCap = LazyOptional.empty();
    protected LazyOptional<IFluidHandler> externalCap = LazyOptional.empty();

    public FluidFilterAttachment(IDuct<?, ?> duct, Direction side) {
        this.duct = duct;
        this.side = side;
    }

    public FilterMode getFilterMode() {
        return this.mode;
    }

    public void setFilterMode(FilterMode mode) {
        this.mode = mode;
        AttachmentConfigPacket.sendToServer(this);
    }

    @Override
    public IDuct<?, ?> duct() {
        return this.duct;
    }

    @Override
    public Direction side() {
        return this.side;
    }

    @Override
    public IAttachment read(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            return this;
        }
        this.mode = FilterMode.VALUES[nbt.m_128445_("Mode")];
        this.filter.read(nbt);
        this.rsControl.read(nbt);
        return this;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        nbt.m_128359_("Type", "filter");
        nbt.m_128344_("Mode", (byte)this.mode.ordinal());
        this.filter.write(nbt);
        this.rsControl.write(nbt);
        return nbt;
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)ThermalCore.ITEMS.get("filter_attachment"));
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.mode) {
            case TO_EXTERNAL_ONLY: {
                return this.rsControl.getState() ? TDynTextures.FILTER_ATTACHMENT_TO_EXTERNAL_ACTIVE_LOC : TDynTextures.FILTER_ATTACHMENT_TO_EXTERNAL_LOC;
            }
            case TO_GRID_ONLY: {
                return this.rsControl.getState() ? TDynTextures.FILTER_ATTACHMENT_TO_GRID_ACTIVE_LOC : TDynTextures.FILTER_ATTACHMENT_TO_GRID_LOC;
            }
        }
        return this.rsControl.getState() ? TDynTextures.FILTER_ATTACHMENT_ACTIVE_LOC : TDynTextures.FILTER_ATTACHMENT_LOC;
    }

    public Component m_5446_() {
        return DISPLAY_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new FluidFilterAttachmentContainer(i, player.m_183503_(), this.pos(), this.side, inventory, player);
    }

    @Override
    public <T> LazyOptional<T> wrapGridCapability(@Nonnull Capability<T> cap, @Nonnull LazyOptional<T> gridLazOpt) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Object t;
            if (this.gridCap.isPresent()) {
                return this.gridCap.cast();
            }
            Optional gridOpt = gridLazOpt.resolve();
            if (gridOpt.isPresent() && (t = gridOpt.get()) instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)t;
                this.gridCap = LazyOptional.of(() -> new WrappedGridFluidHandler(handler, e -> this.rsControl.getState() && this.filter.valid(e) || !this.rsControl.getState()));
                gridLazOpt.addListener(e -> this.gridCap.invalidate());
                return this.gridCap.cast();
            }
        }
        return gridLazOpt;
    }

    @Override
    public <T> LazyOptional<T> wrapExternalCapability(@Nonnull Capability<T> cap, @Nonnull LazyOptional<T> extLazOpt) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            Object t;
            if (this.externalCap.isPresent()) {
                return this.externalCap.cast();
            }
            Optional extOpt = extLazOpt.resolve();
            if (extOpt.isPresent() && (t = extOpt.get()) instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)t;
                this.externalCap = LazyOptional.of(() -> new WrappedExternalFluidHandler(handler, e -> this.rsControl.getState() && this.filter.valid(e) || !this.rsControl.getState()));
                extLazOpt.addListener(e -> this.externalCap.invalidate());
                return this.externalCap.cast();
            }
        }
        return extLazOpt;
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        buffer.writeByte(this.mode.ordinal());
        buffer.writeBoolean(this.filter.getAllowList());
        buffer.writeBoolean(this.filter.getCheckNBT());
        return buffer;
    }

    @Override
    public void handleConfigPacket(FriendlyByteBuf buffer) {
        FilterMode prevMode = this.mode;
        this.mode = FilterMode.VALUES[buffer.readByte()];
        this.filter.setAllowList(buffer.readBoolean());
        this.filter.setCheckNBT(buffer.readBoolean());
        if (this.mode != prevMode) {
            this.onControlUpdate();
        }
    }

    @Override
    public FriendlyByteBuf getControlPacket(FriendlyByteBuf buffer) {
        buffer.writeByte(this.mode.ordinal());
        this.rsControl.writeToBuffer(buffer);
        return buffer;
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        this.mode = FilterMode.VALUES[buffer.readByte()];
        this.rsControl.readFromBuffer(buffer);
    }

    @Override
    public RedstoneControlLogic redstoneControl() {
        return this.rsControl;
    }

    public void readConveyableData(Player player, CompoundTag tag) {
        this.rsControl.readSettings(tag);
        this.filter.read(tag);
    }

    public void writeConveyableData(Player player, CompoundTag tag) {
        this.rsControl.writeSettings(tag);
        this.filter.write(tag);
    }

    public static enum FilterMode {
        BIDIRECTIONAL,
        TO_EXTERNAL_ONLY,
        TO_GRID_ONLY;

        public static final FilterMode[] VALUES;

        static {
            VALUES = FilterMode.values();
        }
    }

    private class WrappedExternalFluidHandler
    implements IFluidHandler {
        protected IFluidHandler wrappedHandler;
        protected Predicate<FluidStack> validator;

        public WrappedExternalFluidHandler(IFluidHandler wrappedHandler, Predicate<FluidStack> validator) {
            this.wrappedHandler = wrappedHandler;
            this.validator = validator;
        }

        public int getTanks() {
            return this.wrappedHandler.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedHandler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrappedHandler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_GRID_ONLY) {
                return false;
            }
            return this.validator.test(stack) && this.wrappedHandler.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_GRID_ONLY) {
                return 0;
            }
            return this.validator.test(resource) ? this.wrappedHandler.fill(resource, action) : 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_EXTERNAL_ONLY) {
                return FluidStack.EMPTY;
            }
            return this.validator.test(resource) ? this.wrappedHandler.drain(resource, action) : FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_EXTERNAL_ONLY) {
                return FluidStack.EMPTY;
            }
            return this.validator.test(this.wrappedHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE)) ? this.wrappedHandler.drain(maxDrain, action) : FluidStack.EMPTY;
        }
    }

    private class WrappedGridFluidHandler
    implements IFluidHandler {
        protected IFluidHandler wrappedHandler;
        protected Predicate<FluidStack> validator;

        public WrappedGridFluidHandler(IFluidHandler wrappedHandler, Predicate<FluidStack> validator) {
            this.wrappedHandler = wrappedHandler;
            this.validator = validator;
        }

        public int getTanks() {
            return this.wrappedHandler.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.wrappedHandler.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.wrappedHandler.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_EXTERNAL_ONLY) {
                return false;
            }
            return this.validator.test(stack) && this.wrappedHandler.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_EXTERNAL_ONLY) {
                return 0;
            }
            return this.validator.test(resource) ? this.wrappedHandler.fill(resource, action) : 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_GRID_ONLY) {
                return FluidStack.EMPTY;
            }
            return this.validator.test(resource) ? this.wrappedHandler.drain(resource, action) : FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (FluidFilterAttachment.this.mode == FilterMode.TO_GRID_ONLY) {
                return FluidStack.EMPTY;
            }
            return this.validator.test(this.wrappedHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE)) ? this.wrappedHandler.drain(maxDrain, action) : FluidStack.EMPTY;
        }
    }
}

