/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.block.entity.duct;

import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.thermal.dynamics.api.grid.IGridHostLuminous;
import cofh.thermal.dynamics.api.grid.IGridHostUpdateable;
import cofh.thermal.dynamics.block.entity.duct.FluidDuctBlockEntity;
import cofh.thermal.dynamics.grid.fluid.FluidGrid;
import cofh.thermal.dynamics.init.TDynBlockEntities;
import cofh.thermal.dynamics.util.TDynConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;

public class FluidDuctWindowedBlockEntity
extends FluidDuctBlockEntity
implements IGridHostUpdateable,
IGridHostLuminous,
IPacketHandlerTile {
    FluidStack renderFluid = FluidStack.EMPTY;
    protected int prevLight;

    public FluidDuctWindowedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TDynBlockEntities.FLUID_DUCT_WINDOWED_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void update() {
        TileStatePacket.sendToClient((IPacketHandlerTile)this);
    }

    @Override
    public int getLightValue() {
        return FluidHelper.luminosity((FluidStack)this.renderFluid);
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        this.modelData.setFill(this.renderFluid.isEmpty() ? TDynConstants.BLANK_TEXTURE : RenderHelper.getFluidTexture((FluidStack)this.renderFluid).m_118413_());
        this.modelData.setFillColor(FluidHelper.color((FluidStack)this.renderFluid));
        return super.getModelData();
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        if (!this.renderFluid.isEmpty()) {
            tag.m_128365_("RenderFluid", (Tag)this.renderFluid.writeToNBT(new CompoundTag()));
        }
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.renderFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("RenderFluid"));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        this.renderFluid = ((FluidGrid)this.getGrid()).getRenderFluid();
        buffer.writeFluidStack(this.renderFluid);
        buffer.writeInt(this.prevLight);
        super.getStatePacket(buffer);
        return buffer;
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        this.renderFluid = buffer.readFluidStack();
        this.prevLight = buffer.readInt();
        if (this.prevLight != this.getLightValue()) {
            this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
        }
        super.handleStatePacket(buffer);
    }
}

