/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportationUtils {
    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        return TeleportationUtils.teleportEntityTo(entity, new BlockPos(xCoord, yCoord, zCoord), dimension, yaw, pitch);
    }

    public static Entity teleportEntityTo(Entity entity, BlockPos target, ResourceKey<Level> destinationDimension, final float yaw, final float pitch) {
        if (entity.m_20193_().m_46472_() == destinationDimension) {
            entity.m_146922_(yaw);
            entity.m_146926_(pitch);
            entity.m_6021_((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
            if (!entity.m_20197_().isEmpty()) {
                ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, (Packet)new ClientboundSetPassengersPacket(entity));
            }
            return entity;
        }
        ServerLevel newWorld = ((ServerLevel)entity.m_20193_()).m_142572_().m_129880_(destinationDimension);
        if (newWorld != null) {
            final Vec3 destination = new Vec3((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5);
            final List passengers = entity.m_20197_();
            return entity.changeDimension(newWorld, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw2, Function<Boolean, Entity> repositionEntity) {
                    Entity repositionedEntity = repositionEntity.apply(false);
                    if (repositionedEntity != null) {
                        for (Entity passenger : passengers) {
                            TeleportationUtils.teleportPassenger(destWorld, repositionedEntity, passenger);
                        }
                    }
                    return repositionedEntity;
                }

                public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                    return new PortalInfo(destination, entity.m_20184_(), yaw, pitch);
                }
            });
        }
        return null;
    }

    private static void teleportPassenger(ServerLevel destWorld, final Entity repositionedEntity, Entity passenger) {
        final List passengers = passenger.m_20197_();
        passenger.changeDimension(destWorld, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedPassenger = repositionEntity.apply(false);
                if (repositionedPassenger != null) {
                    repositionedPassenger.m_7998_(repositionedEntity, true);
                    for (Entity passenger : passengers) {
                        TeleportationUtils.teleportPassenger(destWorld, repositionedPassenger, passenger);
                    }
                }
                return repositionedPassenger;
            }
        });
    }
}

