/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.client.models.ModelIEArmorBase;
import blusunrize.immersiveengineering.client.models.obj.callback.item.PowerpackCallbacks;
import blusunrize.immersiveengineering.client.render.ConnectionRenderer;
import blusunrize.immersiveengineering.client.render.tile.ShaderBannerRenderer;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ModelPowerpack {
    private static final Supplier<ArmorModel> MODEL = Suppliers.memoize(() -> {
        EntityModelSet models = Minecraft.m_91087_().m_167973_();
        ModelPart layer = models.m_171103_(ModelLayers.f_171162_);
        return new ArmorModel(layer);
    });
    public static Map<UUID, Connection> PLAYER_ATTACHED_TO = new HashMap<UUID, Connection>();
    private static final Cache<BannerKey, List<BannerLayer>> bannerCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    public static final LoadingCache<CatenaryKey, Connection.CatenaryData> CATENARY_DATA_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(CacheLoader.from(key -> {
        double angleX = (double)key.xTimes1024() / 1024.0;
        double angleZ = (double)key.zTimes1024() / 1024.0;
        double armLength = 0.75;
        double x = 0.3125 + (double)(key.right ? 1 : -1) * armLength * Math.sin(angleZ);
        double y = armLength * Math.cos(angleX);
        double z = armLength * Math.sin(angleX);
        double zFrom = key.crouched ? 0.625 : 0.25;
        double slack = key.crouched ? 1.25 : 1.5;
        return Connection.makeCatenaryData(new Vec3(0.484375, -0.75, zFrom), new Vec3(x, -y, z), slack);
    }));

    public static void render(LivingEntity toRender, ItemStack powerpack, PoseStack matrixStackIn, MultiBufferSource buffers, int packedLightIn, int packedOverlayIn, float limbSwing, float limbSwingAmount, float ageInTicks, float partialTicks, float netHeadYaw, float headPitch) {
        ArmorModel model = MODEL.get();
        model.m_6973_(toRender, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (powerpack != null) {
            float max = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)powerpack);
            float f = Math.max(0.0f, (float)EnergyHelper.getEnergyStored((ICapabilityProvider)powerpack) / max);
        }
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(new Quaternion(180.0f, 0.0f, 0.0f, true));
        if (model.f_102817_) {
            matrixStackIn.m_85837_(0.0, (double)-0.2f, 0.0);
            matrixStackIn.m_85845_(new Quaternion(0.5f, 0.0f, 0.0f, false));
        }
        matrixStackIn.m_85837_(0.0, -0.37, -0.187);
        ItemStack banner = PowerpackItem.getBannerStatic(powerpack);
        if (!banner.m_41619_()) {
            matrixStackIn.m_85836_();
            InteractionHand[] shaderTexture = ShaderBannerRenderer.getShaderResourceLocation(banner, new ResourceLocation("immersiveengineering", "banner"));
            if (shaderTexture != null) {
                PowerpackCallbacks.THIRD_PERSON_PASS = 3;
                bakedModel = renderer.m_174264_(powerpack, toRender.m_183503_(), toRender, 0);
                bakedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)bakedModel, (ItemTransforms.TransformType)ItemTransforms.TransformType.FIXED, (boolean)false);
                matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
                VertexConsumer consumer = buffers.m_6299_(RenderType.m_110446_((ResourceLocation)shaderTexture));
                Minecraft.m_91087_().m_91291_().m_115189_(bakedModel, powerpack, 0xF000F0, OverlayTexture.f_118083_, matrixStackIn, consumer);
            } else {
                PowerpackCallbacks.THIRD_PERSON_PASS = 2;
                bakedModel = renderer.m_174264_(powerpack, toRender.m_183503_(), toRender, 0);
                bakedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)bakedModel, (ItemTransforms.TransformType)ItemTransforms.TransformType.FIXED, (boolean)false);
                matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
                for (BannerLayer layer : ModelPowerpack.getBannerLayers(banner, bakedModel)) {
                    VertexConsumer consumer = layer.getConsumer.apply(buffers);
                    for (BakedQuad quad : layer.bakedQuads()) {
                        consumer.putBulkData(matrixStackIn.m_85850_(), quad, layer.red(), layer.green(), layer.blue(), 1.0f, 0xF000F0, OverlayTexture.f_118083_, false);
                    }
                }
            }
            matrixStackIn.m_85849_();
            PowerpackCallbacks.THIRD_PERSON_PASS = 1;
        }
        Minecraft.m_91087_().m_91291_().m_115143_(powerpack, ItemTransforms.TransformType.FIXED, false, matrixStackIn, buffers, 0xF000F0, OverlayTexture.f_118083_, renderer.m_174264_(powerpack, toRender.m_183503_(), toRender, 0));
        PowerpackCallbacks.THIRD_PERSON_PASS = 0;
        matrixStackIn.m_85849_();
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = toRender.m_21120_(hand);
            if (stack.m_41619_() || !EnergyHelper.isFluxRelated((ICapabilityProvider)stack)) continue;
            boolean right = hand == InteractionHand.MAIN_HAND == (toRender.m_5737_() == HumanoidArm.RIGHT);
            float angleX = (right ? model.f_102811_ : model.f_102812_).f_104203_;
            float angleZ = (right ? model.f_102811_ : model.f_102812_).f_104205_;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(right ? -1.0f : 1.0f, -1.0f, 1.0f);
            TransformingVertexBuilder builder = new TransformingVertexBuilder(buffers, RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_), matrixStackIn);
            ConnectionRenderer.renderConnection(builder, (Connection.CatenaryData)CATENARY_DATA_CACHE.getUnchecked((Object)new CatenaryKey((int)(1024.0f * angleX), (int)(1024.0f * angleZ), model.f_102817_, right)), -0.015625, 15573060, packedLightIn, packedOverlayIn);
            matrixStackIn.m_85849_();
        }
        CompoundTag upgrades = PowerpackItem.getUpgradesStatic(powerpack);
        if (upgrades.m_128471_("antenna")) {
            Vec3 antennaBase = new Vec3(-0.09375, -0.3125, 0.21875).m_82524_((float)Math.toRadians(-toRender.f_20884_));
            Vec3 antennaTip = antennaBase.m_82520_(0.0, -2.5, 0.0);
            double distFromWire = 0.0;
            if (PLAYER_ATTACHED_TO.containsKey(toRender.m_142081_())) {
                Connection connection = PLAYER_ATTACHED_TO.get(toRender.m_142081_());
                Connection.CatenaryData catenary = connection.getCatenaryData();
                Vec3 a = Vec3.m_82528_((Vec3i)connection.getEndA().position());
                Vec3 ap = antennaTip.m_82549_(toRender.m_20182_()).m_82546_(a);
                Vec3 connectionDir = catenary.delta().m_82541_();
                distFromWire = ap.m_82537_(connectionDir).m_82553_();
                double orthLength = ap.m_82526_(catenary.delta()) / catenary.delta().m_82526_(catenary.delta());
                Vec3 catPoint = connection.getPoint(orthLength, connection.getEndA());
                antennaTip = toRender.m_20182_().m_82520_(0.0, 1.25, 0.0).m_82546_(a.m_82549_(catPoint)).m_82490_(1.02);
            }
            matrixStackIn.m_85836_();
            matrixStackIn.m_85845_(new Quaternion(Vector3f.f_122225_, -toRender.f_20884_, true));
            matrixStackIn.m_85841_(-1.0f, 1.0f, 1.0f);
            Connection.CatenaryData renderCat = Connection.makeCatenaryData(antennaBase, antennaTip, 1.0 + distFromWire * 0.005);
            ConnectionRenderer.renderConnection(new TransformingVertexBuilder(buffers, RenderType.m_110446_((ResourceLocation)InventoryMenu.f_39692_), matrixStackIn), renderCat, -0.03125, 10792880, packedLightIn, packedOverlayIn);
            matrixStackIn.m_85849_();
        }
    }

    private static List<BannerLayer> getBannerLayers(ItemStack banner, BakedModel bakedModel) {
        ListTag patternList;
        BannerKey key;
        ArrayList<BannerLayer> cached;
        Block block;
        DyeColor baseCol = DyeColor.WHITE;
        if (banner.m_41720_() instanceof BlockItem && (block = ((BlockItem)banner.m_41720_()).m_40614_()) instanceof AbstractBannerBlock) {
            AbstractBannerBlock bannerBlock = (AbstractBannerBlock)block;
            baseCol = bannerBlock.m_48674_();
        }
        if ((cached = (ArrayList<BannerLayer>)bannerCache.getIfPresent((Object)(key = new BannerKey(baseCol, (patternList = BannerBlockEntity.m_58487_((ItemStack)banner)) != null ? patternList.toString() : "")))) != null) {
            return cached;
        }
        List list = BannerBlockEntity.m_58484_((DyeColor)baseCol, (ListTag)patternList);
        List quads = bakedModel.m_6840_(null, null, new Random(42L));
        cached = new ArrayList<BannerLayer>(quads.size() * list.size());
        for (int i = 0; i < 17 && i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            BannerPattern bannerpattern = (BannerPattern)pair.getFirst();
            Material material = Sheets.m_173383_((BannerPattern)bannerpattern);
            float[] colour = ((DyeColor)pair.getSecond()).m_41068_();
            cached.add(new BannerLayer(mbs -> material.m_119194_(mbs, RenderType::m_110464_), colour[0], colour[1], colour[2], quads));
        }
        bannerCache.put((Object)key, cached);
        return cached;
    }

    private static class ArmorModel
    extends ModelIEArmorBase {
        public ArmorModel(ModelPart part) {
            super(part, RenderType::m_110473_);
        }
    }

    private record BannerLayer(Function<MultiBufferSource, VertexConsumer> getConsumer, float red, float green, float blue, List<BakedQuad> bakedQuads) {
    }

    private record CatenaryKey(int xTimes1024, int zTimes1024, boolean crouched, boolean right) {
    }

    private record BannerKey(DyeColor base, String patternText) {
    }
}

