/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelBlockEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.Nullable;

public class BucketWheelCallbacks
implements BlockCallback<Key> {
    public static final BucketWheelCallbacks INSTANCE = new BucketWheelCallbacks();
    private static final Key INVALID = new Key(Collections.emptyMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof BucketWheelBlockEntity)) {
            return this.getDefaultKey();
        }
        BucketWheelBlockEntity bucketWheel = (BucketWheelBlockEntity)blockEntity;
        HashMap<String, TextureAtlasSprite> texMap = new HashMap<String, TextureAtlasSprite>();
        NonNullList<ItemStack> nonNullList = bucketWheel.digStacks;
        synchronized (nonNullList) {
            for (int i = 0; i < bucketWheel.digStacks.size(); ++i) {
                ItemStack stackAtIndex = (ItemStack)bucketWheel.digStacks.get(i);
                if (stackAtIndex.m_41619_()) continue;
                Block b = Block.m_49814_((Item)stackAtIndex.m_41720_());
                BlockState digState = b != Blocks.f_50016_ ? b.m_49966_() : Blocks.f_50652_.m_49966_();
                BakedModel digModel = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(digState);
                texMap.put("dig" + i, digModel.getParticleIcon((IModelData)EmptyModelData.INSTANCE));
            }
        }
        return new Key(texMap);
    }

    @Override
    @Nullable
    public TextureAtlasSprite getTextureReplacement(Key key, String group, String material) {
        return key.texMap.get(group);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public boolean shouldRenderGroup(Key key, String group, RenderType layer) {
        return "bucketWheel".equals(group) || key.texMap.containsKey(group);
    }

    public record Key(Map<String, TextureAtlasSprite> texMap) {
    }
}

