/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.links.EntryWithLinks;
import blusunrize.lib.manual.links.Link;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.io.IOUtils;

public class ManualEntry
implements Comparable<ManualEntry> {
    private boolean initialized = false;
    private final ManualInstance manual;
    private final Supplier<EntryData> getContent;
    private final ResourceLocation location;
    private String title;
    private String subtext;
    private List<SpecialElementData> specialElements;
    private Supplier<EntryWithLinks> withLinks;
    private Supplier<Set<String>> anchors;
    private List<ManualPage> pages;
    private Int2ObjectMap<SpecialManualElement> specials;
    private Object2IntMap<String> anchorPoints;
    public static final SpecialManualElement NOT_SPECIAL = new SpecialManualElement(){

        @Override
        public void onOpened(ManualScreen m, int x, int y, List<Button> buttons) {
        }

        @Override
        public int getPixelsTaken() {
            return 0;
        }

        @Override
        public void render(PoseStack transform, ManualScreen m, int x, int y, int mouseX, int mouseY) {
        }

        @Override
        public void mouseDragged(int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int mouseButton) {
        }

        @Override
        public boolean listForSearch(String searchTag) {
            return false;
        }

        @Override
        public void recalculateCraftingRecipes() {
        }
    };

    private ManualEntry(ManualInstance m, Supplier<EntryData> getContent, ResourceLocation location) {
        this.manual = m;
        this.getContent = getContent;
        this.location = location;
    }

    public void initBasic() {
        EntryData data = this.getContent.get();
        this.title = data.title;
        this.subtext = data.subtext;
        String formattedText = this.manual.formatText(data.content);
        this.specialElements = data.specialElements;
        this.withLinks = Suppliers.memoize(() -> new EntryWithLinks(formattedText, this.manual));
        this.anchors = Suppliers.memoize(() -> {
            HashSet<String> anchors = new HashSet<String>();
            for (Either<String, Link> e : this.withLinks.get().getUnsplitTokens()) {
                String s;
                Optional left = e.left();
                if (!left.isPresent() || !(s = (String)left.get()).startsWith("<&") || !s.endsWith(">")) continue;
                anchors.add(s.substring(2, s.length() - 1));
            }
            anchors.add("start");
            return anchors;
        });
        this.initialized = false;
    }

    private void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        try {
            this.manual.entryRenderPre();
            TextSplitter splitter = new TextSplitter(this.manual);
            for (SpecialElementData special : this.specialElements) {
                splitter.addSpecialPage(special.anchor, special.offset, special.getElement());
            }
            SplitResult result = splitter.split(this.withLinks.get().getUnsplitTokens());
            this.specials = result.specialByPage;
            this.anchorPoints = result.pageByAnchor;
            List<List<List<SplitResult.Token>>> text = result.entry;
            this.pages = new ArrayList<ManualPage>(text.size());
            for (int i = 0; i < text.size(); ++i) {
                SpecialManualElement special = (SpecialManualElement)this.specials.get(i);
                if (special == null) {
                    special = NOT_SPECIAL;
                }
                this.pages.add(new ManualPage(text.get(i), special));
            }
            this.manual.entryRenderPost();
        }
        catch (Exception x) {
            throw new RuntimeException("Exception while refreshing manual entry " + this.location + " for manual " + this.manual.getManualName(), x);
        }
        this.initialized = true;
    }

    public void renderPage(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        this.ensureInitialized();
        int page = gui.page;
        ManualPage toRender = this.pages.get(page);
        int offsetText = 0;
        int n = toRender.renderText.size();
        Objects.requireNonNull(this.manual.fontRenderer());
        int offsetSpecial = (n * 9 + 1 + this.manual.pageHeight - toRender.special.getPixelsTaken()) / 2;
        ManualInstance manual = gui.getManual();
        if (toRender.special.isAbove()) {
            offsetText = toRender.special.getPixelsTaken();
            offsetSpecial = 0;
        }
        ManualUtils.drawSplitString(transform, manual.fontRenderer(), toRender.renderText, x, y + offsetText, manual.getTextColour());
        transform.m_85836_();
        transform.m_85837_((double)x, (double)(y + offsetSpecial), 0.0);
        toRender.special.render(transform, gui, 0, 0, mouseX, mouseY);
        transform.m_85849_();
    }

    public String getTitle() {
        return this.title;
    }

    public List<SpecialElementData> getSpecialData() {
        return this.specialElements;
    }

    public Int2ObjectMap<SpecialManualElement> getSpecialsByPage() {
        this.ensureInitialized();
        return this.specials;
    }

    public void addButtons(ManualScreen gui, int x, int y, int page, List<Button> pageButtons) {
        this.ensureInitialized();
        ManualPage p = this.pages.get(page);
        p.renderText = p.text.stream().map(l -> l.stream().map(SplitResult.Token::getText).collect(Collectors.joining())).collect(Collectors.toList());
        ManualUtils.addLinkButtons(this, this.manual, gui, p.text, x, y + p.special.getPixelsTaken(), pageButtons);
        ArrayList<Button> tempButtons = new ArrayList<Button>();
        this.pages.get((int)gui.page).special.onOpened(gui, 0, 0, tempButtons);
        for (Button btn : tempButtons) {
            btn.f_93620_ += x;
            btn.f_93621_ += y;
            pageButtons.add(btn);
        }
    }

    public String getSubtext() {
        return this.subtext;
    }

    public int getPageCount() {
        this.ensureInitialized();
        return this.pages.size();
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public ItemStack getHighlightedStack(int page) {
        this.ensureInitialized();
        return this.pages.get((int)page).special.getHighlightedStack();
    }

    public boolean listForSearch(String search) {
        for (SpecialElementData d : this.specialElements) {
            if (!d.getElement().listForSearch(search)) continue;
            return true;
        }
        return false;
    }

    public void mouseDragged(ManualScreen gui, int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int button) {
        this.ensureInitialized();
        this.pages.get((int)gui.page).special.mouseDragged(x, y, clickX, clickY, mx, my, lastX, lastY, button);
    }

    public int getPageForAnchor(String anchor) {
        this.ensureInitialized();
        return this.anchorPoints.getInt((Object)anchor);
    }

    public boolean hasAnchor(String anchor) {
        return this.anchors.get().contains(anchor);
    }

    public Tree.AbstractNode<ResourceLocation, ManualEntry> getTreeNode() {
        return this.manual.getAllEntriesAndCategories().filter(e -> e.getLeafData() == this).findAny().orElse(null);
    }

    @Override
    public int compareTo(ManualEntry o) {
        return this.title.compareTo(o.title);
    }

    public static class EntryData {
        private final String title;
        private final String subtext;
        private final String content;
        private final List<SpecialElementData> specialElements;

        public EntryData(String title, String subtext, String content, List<SpecialElementData> specialElements) {
            this.title = title;
            this.subtext = subtext;
            this.content = content;
            this.specialElements = specialElements;
        }
    }

    public static class SpecialElementData {
        private final String anchor;
        private final int offset;
        private final Supplier<? extends SpecialManualElement> element;

        public SpecialElementData(String anchor, int offset, SpecialManualElement element) {
            this(anchor, offset, () -> element);
        }

        public SpecialElementData(String anchor, int offset, Supplier<? extends SpecialManualElement> element) {
            this.anchor = anchor;
            this.offset = offset;
            this.element = Suppliers.memoize(element::get);
        }

        public SpecialManualElement getElement() {
            return this.element.get();
        }

        public String getAnchor() {
            return this.anchor;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static class ManualPage {
        public List<String> renderText;
        List<List<SplitResult.Token>> text;
        @Nonnull
        SpecialManualElement special;

        public ManualPage(List<List<SplitResult.Token>> text, @Nonnull SpecialManualElement special) {
            this.text = text;
            this.special = special;
        }
    }

    public static class ManualEntryBuilder {
        private final ManualInstance manual;
        private Supplier<EntryData> getContent = null;
        private ResourceLocation location;
        private final List<SpecialElementData> hardcodedSpecials = new ArrayList<SpecialElementData>();
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ManualEntryBuilder(ManualInstance manual) {
            this.manual = manual;
        }

        public ManualEntryBuilder(@Nonnull ManualInstance manual, @Nonnull TextSplitter splitter) {
            this.manual = manual;
        }

        public void addSpecialElement(SpecialElementData data) {
            this.hardcodedSpecials.add(data);
        }

        public void setContent(Supplier<EntryData> get) {
            this.getContent = () -> {
                EntryData base = (EntryData)get.get();
                ArrayList<SpecialElementData> allSpecials = new ArrayList<SpecialElementData>(base.specialElements);
                allSpecials.addAll(this.hardcodedSpecials);
                return new EntryData(base.title, base.subtext, base.content, allSpecials);
            };
        }

        public void setContent(Supplier<String> title, Supplier<String> subText, Supplier<String> mainText) {
            this.getContent = () -> new EntryData((String)title.get(), (String)subText.get(), (String)mainText.get(), this.hardcodedSpecials);
        }

        public void setContent(String title, String subText, String mainText) {
            this.setContent(() -> title, () -> subText, () -> mainText);
        }

        public void appendText(Supplier<Pair<String, List<SpecialElementData>>> text) {
            Supplier<EntryData> old = this.getContent;
            this.setContent(() -> {
                EntryData base = (EntryData)old.get();
                Pair toAdd = (Pair)text.get();
                ArrayList<SpecialElementData> allSpecials = new ArrayList<SpecialElementData>(base.specialElements);
                allSpecials.addAll((Collection)toAdd.getSecond());
                return new EntryData(base.title, base.subtext, base.content + (String)toAdd.getFirst(), allSpecials);
            });
        }

        public void readFromFile(ResourceLocation name) {
            this.location = name;
            this.getContent = () -> {
                Resource resData;
                ResourceLocation langLoc = new ResourceLocation(name.m_135827_(), "manual/" + Minecraft.m_91087_().m_91102_().m_118983_().getCode() + "/" + name.m_135815_() + ".txt");
                ResourceLocation dataLoc = new ResourceLocation(name.m_135827_(), "manual/" + name.m_135815_() + ".json");
                Resource resLang = ManualEntryBuilder.getResourceNullable(langLoc);
                ResourceManager manager = Minecraft.m_91087_().m_91098_();
                try {
                    resData = manager.m_142591_(dataLoc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (resLang == null) {
                    resLang = ManualEntryBuilder.getResourceNullable(new ResourceLocation(name.m_135827_(), "manual/en_us/" + name.m_135815_() + ".txt"));
                }
                if (resLang == null) {
                    return new EntryData("ERROR", "This is not a good thing", "Could not find the file for " + name, (List<SpecialElementData>)ImmutableList.of());
                }
                try {
                    JsonObject json = (JsonObject)GsonHelper.m_13780_((Gson)GSON, (Reader)new InputStreamReader(resData.m_6679_()), JsonObject.class, (boolean)true);
                    byte[] bytesLang = IOUtils.toByteArray((InputStream)resLang.m_6679_());
                    String content = new String(bytesLang, StandardCharsets.UTF_8);
                    ArrayList<SpecialElementData> allSpecials = new ArrayList<SpecialElementData>(this.hardcodedSpecials);
                    assert (json != null);
                    ManualUtils.parseSpecials(json, this.manual, allSpecials);
                    int titleEnd = content.indexOf(10);
                    String title = content.substring(0, titleEnd).trim();
                    content = content.substring(titleEnd + 1);
                    int subtitleEnd = content.indexOf(10);
                    String subtext = content.substring(0, subtitleEnd).trim();
                    content = content.substring(subtitleEnd + 1).trim();
                    Pattern backslashNewline = Pattern.compile("[^\\\\][\\\\][\r]?\n[\r]?");
                    String rawText = backslashNewline.matcher(content).replaceAll("").replace("\\\\", "\\");
                    return new EntryData(title, subtext, rawText, allSpecials);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load manual entry from " + name, e);
                }
            };
        }

        public void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public ManualEntry create() {
            Preconditions.checkNotNull((Object)this.manual);
            Preconditions.checkNotNull(this.getContent);
            Preconditions.checkNotNull((Object)this.location);
            return new ManualEntry(this.manual, this.getContent, this.location);
        }

        private static Resource getResourceNullable(ResourceLocation rl) {
            try {
                return Minecraft.m_91087_().m_91098_().m_142591_(rl);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

