/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector3i;
import net.minecraft.class_285;

public final class ComputeProgram
extends GlResource {
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private Vector3i absoluteWorkGroups;
    private Vector2f relativeWorkGroups;
    private int[] localSize = new int[3];
    private float cachedWidth;
    private float cachedHeight;
    private Vector3i cachedWorkGroups;

    ComputeProgram(int n, ProgramUniforms programUniforms, ProgramSamplers programSamplers, ProgramImages programImages) {
        super(n);
        IrisRenderSystem.getProgramiv(n, 33383, this.localSize);
        this.uniforms = programUniforms;
        this.samplers = programSamplers;
        this.images = programImages;
    }

    public void setWorkGroupInfo(Vector2f vector2f, Vector3i vector3i) {
        this.relativeWorkGroups = vector2f;
        this.absoluteWorkGroups = vector3i;
    }

    public Vector3i getWorkGroups(float f, float f2) {
        if (this.cachedWidth != f || this.cachedHeight != f2 || this.cachedWorkGroups == null) {
            this.cachedWidth = f;
            this.cachedHeight = f2;
            this.cachedWorkGroups = this.absoluteWorkGroups != null ? this.absoluteWorkGroups : (this.relativeWorkGroups != null ? new Vector3i((int)Math.ceil(Math.ceil(f * this.relativeWorkGroups.x) / (double)this.localSize[0]), (int)Math.ceil(Math.ceil(f2 * this.relativeWorkGroups.y) / (double)this.localSize[1]), 1) : new Vector3i((int)Math.ceil(f / (float)this.localSize[0]), (int)Math.ceil(f2 / (float)this.localSize[1]), 1));
        }
        return this.cachedWorkGroups;
    }

    public void use() {
        class_285.method_22094((int)this.getGlId());
        this.uniforms.update();
        this.samplers.update();
        this.images.update();
    }

    public void dispatch(float f, float f2) {
        if (!Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::allowConcurrentCompute).orElse(false).booleanValue()) {
            IrisRenderSystem.memoryBarrier(8232);
        }
        IrisRenderSystem.dispatchCompute(this.getWorkGroups(f, f2));
    }

    public static void unbind() {
        ProgramUniforms.clearActiveUniforms();
        class_285.method_22094((int)0);
    }

    @Override
    public void destroyInternal() {
        GlStateManager.glDeleteProgram((int)this.getGlId());
    }

    @Deprecated
    public int getProgramId() {
        return this.getGlId();
    }

    public int getActiveImages() {
        return this.images.getActiveImages();
    }
}

