/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix2fc;
import net.coderbot.iris.vendored.joml.Matrix3f;
import net.coderbot.iris.vendored.joml.Matrix3fc;
import net.coderbot.iris.vendored.joml.Matrix3x2f;
import net.coderbot.iris.vendored.joml.Matrix3x2fc;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2f;
import net.coderbot.iris.vendored.joml.Vector2fc;

public class Matrix2f
implements Externalizable,
Cloneable,
Matrix2fc {
    private static final long serialVersionUID = 1L;
    public float m00;
    public float m01;
    public float m10;
    public float m11;

    public Matrix2f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
    }

    public Matrix2f(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
    }

    public Matrix2f(Matrix3fc matrix3fc) {
        if (matrix3fc instanceof Matrix3f) {
            MemUtil.INSTANCE.copy((Matrix3f)matrix3fc, this);
        } else {
            this.setMatrix3fc(matrix3fc);
        }
    }

    public Matrix2f(float f, float f2, float f3, float f4) {
        this.m00 = f;
        this.m01 = f2;
        this.m10 = f3;
        this.m11 = f4;
    }

    public Matrix2f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Matrix2f(Vector2fc vector2fc, Vector2fc vector2fc2) {
        this.m00 = vector2fc.x();
        this.m01 = vector2fc.y();
        this.m10 = vector2fc2.x();
        this.m11 = vector2fc2.y();
    }

    @Override
    public float m00() {
        return this.m00;
    }

    @Override
    public float m01() {
        return this.m01;
    }

    @Override
    public float m10() {
        return this.m10;
    }

    @Override
    public float m11() {
        return this.m11;
    }

    public Matrix2f m00(float f) {
        this.m00 = f;
        return this;
    }

    public Matrix2f m01(float f) {
        this.m01 = f;
        return this;
    }

    public Matrix2f m10(float f) {
        this.m10 = f;
        return this;
    }

    public Matrix2f m11(float f) {
        this.m11 = f;
        return this;
    }

    Matrix2f _m00(float f) {
        this.m00 = f;
        return this;
    }

    Matrix2f _m01(float f) {
        this.m01 = f;
        return this;
    }

    Matrix2f _m10(float f) {
        this.m10 = f;
        return this;
    }

    Matrix2f _m11(float f) {
        this.m11 = f;
        return this;
    }

    public Matrix2f set(Matrix2fc matrix2fc) {
        if (matrix2fc instanceof Matrix2f) {
            MemUtil.INSTANCE.copy((Matrix2f)matrix2fc, this);
        } else {
            this.setMatrix2fc(matrix2fc);
        }
        return this;
    }

    private void setMatrix2fc(Matrix2fc matrix2fc) {
        this.m00 = matrix2fc.m00();
        this.m01 = matrix2fc.m01();
        this.m10 = matrix2fc.m10();
        this.m11 = matrix2fc.m11();
    }

    public Matrix2f set(Matrix3x2fc matrix3x2fc) {
        if (matrix3x2fc instanceof Matrix3x2f) {
            MemUtil.INSTANCE.copy((Matrix3x2f)matrix3x2fc, this);
        } else {
            this.setMatrix3x2fc(matrix3x2fc);
        }
        return this;
    }

    private void setMatrix3x2fc(Matrix3x2fc matrix3x2fc) {
        this.m00 = matrix3x2fc.m00();
        this.m01 = matrix3x2fc.m01();
        this.m10 = matrix3x2fc.m10();
        this.m11 = matrix3x2fc.m11();
    }

    public Matrix2f set(Matrix3fc matrix3fc) {
        if (matrix3fc instanceof Matrix3f) {
            MemUtil.INSTANCE.copy((Matrix3f)matrix3fc, this);
        } else {
            this.setMatrix3fc(matrix3fc);
        }
        return this;
    }

    private void setMatrix3fc(Matrix3fc matrix3fc) {
        this.m00 = matrix3fc.m00();
        this.m01 = matrix3fc.m01();
        this.m10 = matrix3fc.m10();
        this.m11 = matrix3fc.m11();
    }

    public Matrix2f mul(Matrix2fc matrix2fc) {
        return this.mul(matrix2fc, this);
    }

    @Override
    public Matrix2f mul(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        float f = this.m00 * matrix2fc.m00() + this.m10 * matrix2fc.m01();
        float f2 = this.m01 * matrix2fc.m00() + this.m11 * matrix2fc.m01();
        float f3 = this.m00 * matrix2fc.m10() + this.m10 * matrix2fc.m11();
        float f4 = this.m01 * matrix2fc.m10() + this.m11 * matrix2fc.m11();
        matrix2f.m00 = f;
        matrix2f.m01 = f2;
        matrix2f.m10 = f3;
        matrix2f.m11 = f4;
        return matrix2f;
    }

    public Matrix2f mulLocal(Matrix2fc matrix2fc) {
        return this.mulLocal(matrix2fc, this);
    }

    @Override
    public Matrix2f mulLocal(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        float f = matrix2fc.m00() * this.m00 + matrix2fc.m10() * this.m01;
        float f2 = matrix2fc.m01() * this.m00 + matrix2fc.m11() * this.m01;
        float f3 = matrix2fc.m00() * this.m10 + matrix2fc.m10() * this.m11;
        float f4 = matrix2fc.m01() * this.m10 + matrix2fc.m11() * this.m11;
        matrix2f.m00 = f;
        matrix2f.m01 = f2;
        matrix2f.m10 = f3;
        matrix2f.m11 = f4;
        return matrix2f;
    }

    public Matrix2f set(float f, float f2, float f3, float f4) {
        this.m00 = f;
        this.m01 = f2;
        this.m10 = f3;
        this.m11 = f4;
        return this;
    }

    public Matrix2f set(float[] fArray) {
        MemUtil.INSTANCE.copy(fArray, 0, this);
        return this;
    }

    public Matrix2f set(Vector2fc vector2fc, Vector2fc vector2fc2) {
        this.m00 = vector2fc.x();
        this.m01 = vector2fc.y();
        this.m10 = vector2fc2.x();
        this.m11 = vector2fc2.y();
        return this;
    }

    @Override
    public float determinant() {
        return this.m00 * this.m11 - this.m10 * this.m01;
    }

    public Matrix2f invert() {
        return this.invert(this);
    }

    @Override
    public Matrix2f invert(Matrix2f matrix2f) {
        float f = 1.0f / this.determinant();
        float f2 = this.m11 * f;
        float f3 = -this.m01 * f;
        float f4 = -this.m10 * f;
        float f5 = this.m00 * f;
        matrix2f.m00 = f2;
        matrix2f.m01 = f3;
        matrix2f.m10 = f4;
        matrix2f.m11 = f5;
        return matrix2f;
    }

    public Matrix2f transpose() {
        return this.transpose(this);
    }

    @Override
    public Matrix2f transpose(Matrix2f matrix2f) {
        matrix2f.set(this.m00, this.m10, this.m01, this.m11);
        return matrix2f;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat(" 0.000E0;-");
        String string = this.toString(decimalFormat);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == 'E') {
                n = i;
            } else {
                if (c == ' ' && n == i - 1) {
                    stringBuffer.append('+');
                    continue;
                }
                if (Character.isDigit(c) && n == i - 1) {
                    stringBuffer.append('+');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String toString(NumberFormat numberFormat) {
        return Runtime.format(this.m00, numberFormat) + " " + Runtime.format(this.m10, numberFormat) + "\n" + Runtime.format(this.m01, numberFormat) + " " + Runtime.format(this.m11, numberFormat) + "\n";
    }

    @Override
    public Matrix2f get(Matrix2f matrix2f) {
        return matrix2f.set(this);
    }

    @Override
    public Matrix3x2f get(Matrix3x2f matrix3x2f) {
        return matrix3x2f.set(this);
    }

    @Override
    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    @Override
    public float getRotation() {
        return Math.atan2(this.m01, this.m11);
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public FloatBuffer getTransposed(FloatBuffer floatBuffer) {
        return this.get(floatBuffer.position(), floatBuffer);
    }

    @Override
    public FloatBuffer getTransposed(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer getTransposed(ByteBuffer byteBuffer) {
        return this.get(byteBuffer.position(), byteBuffer);
    }

    @Override
    public ByteBuffer getTransposed(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putTransposed(this, n, byteBuffer);
        return byteBuffer;
    }

    @Override
    public float[] get(float[] fArray, int n) {
        MemUtil.INSTANCE.copy(this, fArray, n);
        return fArray;
    }

    @Override
    public float[] get(float[] fArray) {
        return this.get(fArray, 0);
    }

    public Matrix2f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Matrix2f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Matrix2f set(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n, floatBuffer);
        return this;
    }

    public Matrix2f set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Matrix2f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Matrix2f identity() {
        MemUtil.INSTANCE.identity(this);
        return this;
    }

    @Override
    public Matrix2f scale(Vector2fc vector2fc, Matrix2f matrix2f) {
        return this.scale(vector2fc.x(), vector2fc.y(), matrix2f);
    }

    public Matrix2f scale(Vector2fc vector2fc) {
        return this.scale(vector2fc.x(), vector2fc.y(), this);
    }

    @Override
    public Matrix2f scale(float f, float f2, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 * f;
        matrix2f.m01 = this.m01 * f;
        matrix2f.m10 = this.m10 * f2;
        matrix2f.m11 = this.m11 * f2;
        return matrix2f;
    }

    public Matrix2f scale(float f, float f2) {
        return this.scale(f, f2, this);
    }

    @Override
    public Matrix2f scale(float f, Matrix2f matrix2f) {
        return this.scale(f, f, matrix2f);
    }

    public Matrix2f scale(float f) {
        return this.scale(f, f);
    }

    @Override
    public Matrix2f scaleLocal(float f, float f2, Matrix2f matrix2f) {
        matrix2f.m00 = f * this.m00;
        matrix2f.m01 = f2 * this.m01;
        matrix2f.m10 = f * this.m10;
        matrix2f.m11 = f2 * this.m11;
        return matrix2f;
    }

    public Matrix2f scaleLocal(float f, float f2) {
        return this.scaleLocal(f, f2, this);
    }

    public Matrix2f scaling(float f) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f;
        this.m11 = f;
        return this;
    }

    public Matrix2f scaling(float f, float f2) {
        MemUtil.INSTANCE.zero(this);
        this.m00 = f;
        this.m11 = f2;
        return this;
    }

    public Matrix2f scaling(Vector2fc vector2fc) {
        return this.scaling(vector2fc.x(), vector2fc.y());
    }

    public Matrix2f rotation(float f) {
        float f2;
        float f3 = Math.sin(f);
        this.m00 = f2 = Math.cosFromSin(f3, f);
        this.m01 = f3;
        this.m10 = -f3;
        this.m11 = f2;
        return this;
    }

    @Override
    public Vector2f transform(Vector2f vector2f) {
        return vector2f.mul(this);
    }

    @Override
    public Vector2f transform(Vector2fc vector2fc, Vector2f vector2f) {
        vector2fc.mul(this, vector2f);
        return vector2f;
    }

    @Override
    public Vector2f transform(float f, float f2, Vector2f vector2f) {
        vector2f.set(this.m00 * f + this.m10 * f2, this.m01 * f + this.m11 * f2);
        return vector2f;
    }

    @Override
    public Vector2f transformTranspose(Vector2f vector2f) {
        return vector2f.mulTranspose(this);
    }

    @Override
    public Vector2f transformTranspose(Vector2fc vector2fc, Vector2f vector2f) {
        vector2fc.mulTranspose(this, vector2f);
        return vector2f;
    }

    @Override
    public Vector2f transformTranspose(float f, float f2, Vector2f vector2f) {
        vector2f.set(this.m00 * f + this.m01 * f2, this.m10 * f + this.m11 * f2);
        return vector2f;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.m00);
        objectOutput.writeFloat(this.m01);
        objectOutput.writeFloat(this.m10);
        objectOutput.writeFloat(this.m11);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.m00 = objectInput.readFloat();
        this.m01 = objectInput.readFloat();
        this.m10 = objectInput.readFloat();
        this.m11 = objectInput.readFloat();
    }

    public Matrix2f rotate(float f) {
        return this.rotate(f, this);
    }

    @Override
    public Matrix2f rotate(float f, Matrix2f matrix2f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.m00 * f3 + this.m10 * f2;
        float f5 = this.m01 * f3 + this.m11 * f2;
        float f6 = this.m10 * f3 - this.m00 * f2;
        float f7 = this.m11 * f3 - this.m01 * f2;
        matrix2f.m00 = f4;
        matrix2f.m01 = f5;
        matrix2f.m10 = f6;
        matrix2f.m11 = f7;
        return matrix2f;
    }

    public Matrix2f rotateLocal(float f) {
        return this.rotateLocal(f, this);
    }

    @Override
    public Matrix2f rotateLocal(float f, Matrix2f matrix2f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = f3 * this.m00 - f2 * this.m01;
        float f5 = f2 * this.m00 + f3 * this.m01;
        float f6 = f3 * this.m10 - f2 * this.m11;
        float f7 = f2 * this.m10 + f3 * this.m11;
        matrix2f.m00 = f4;
        matrix2f.m01 = f5;
        matrix2f.m10 = f6;
        matrix2f.m11 = f7;
        return matrix2f;
    }

    @Override
    public Vector2f getRow(int n, Vector2f vector2f) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                vector2f.x = this.m00;
                vector2f.y = this.m10;
                break;
            }
            case 1: {
                vector2f.x = this.m01;
                vector2f.y = this.m11;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector2f;
    }

    public Matrix2f setRow(int n, Vector2fc vector2fc) throws IndexOutOfBoundsException {
        return this.setRow(n, vector2fc.x(), vector2fc.y());
    }

    public Matrix2f setRow(int n, float f, float f2) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = f;
                this.m10 = f2;
                break;
            }
            case 1: {
                this.m01 = f;
                this.m11 = f2;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    @Override
    public Vector2f getColumn(int n, Vector2f vector2f) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                vector2f.x = this.m00;
                vector2f.y = this.m01;
                break;
            }
            case 1: {
                vector2f.x = this.m10;
                vector2f.y = this.m11;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return vector2f;
    }

    public Matrix2f setColumn(int n, Vector2fc vector2fc) throws IndexOutOfBoundsException {
        return this.setColumn(n, vector2fc.x(), vector2fc.y());
    }

    public Matrix2f setColumn(int n, float f, float f2) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.m00 = f;
                this.m01 = f2;
                break;
            }
            case 1: {
                this.m10 = f;
                this.m11 = f2;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    @Override
    public float get(int n, int n2) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
                break;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix2f set(int n, int n2, float f) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        this.m00 = f;
                        return this;
                    }
                    case 1: {
                        this.m01 = f;
                        return this;
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        this.m10 = f;
                        return this;
                    }
                    case 1: {
                        this.m11 = f;
                        return this;
                    }
                }
                break;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Matrix2f normal() {
        return this.normal(this);
    }

    @Override
    public Matrix2f normal(Matrix2f matrix2f) {
        float f = this.m00 * this.m11 - this.m10 * this.m01;
        float f2 = 1.0f / f;
        float f3 = this.m11 * f2;
        float f4 = -this.m10 * f2;
        float f5 = -this.m01 * f2;
        float f6 = this.m00 * f2;
        matrix2f.m00 = f3;
        matrix2f.m01 = f4;
        matrix2f.m10 = f5;
        matrix2f.m11 = f6;
        return matrix2f;
    }

    @Override
    public Vector2f getScale(Vector2f vector2f) {
        vector2f.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01);
        vector2f.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11);
        return vector2f;
    }

    @Override
    public Vector2f positiveX(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = -this.m11;
            vector2f.y = this.m01;
        } else {
            vector2f.x = this.m11;
            vector2f.y = -this.m01;
        }
        return vector2f.normalize(vector2f);
    }

    @Override
    public Vector2f normalizedPositiveX(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = -this.m11;
            vector2f.y = this.m01;
        } else {
            vector2f.x = this.m11;
            vector2f.y = -this.m01;
        }
        return vector2f;
    }

    @Override
    public Vector2f positiveY(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = this.m10;
            vector2f.y = -this.m00;
        } else {
            vector2f.x = -this.m10;
            vector2f.y = this.m00;
        }
        return vector2f.normalize(vector2f);
    }

    @Override
    public Vector2f normalizedPositiveY(Vector2f vector2f) {
        if (this.m00 * this.m11 < this.m01 * this.m10) {
            vector2f.x = this.m10;
            vector2f.y = -this.m00;
        } else {
            vector2f.x = -this.m10;
            vector2f.y = this.m00;
        }
        return vector2f;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.m00);
        n = 31 * n + Float.floatToIntBits(this.m01);
        n = 31 * n + Float.floatToIntBits(this.m10);
        n = 31 * n + Float.floatToIntBits(this.m11);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix2f matrix2f = (Matrix2f)object;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(matrix2f.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(matrix2f.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(matrix2f.m10)) {
            return false;
        }
        return Float.floatToIntBits(this.m11) == Float.floatToIntBits(matrix2f.m11);
    }

    @Override
    public boolean equals(Matrix2fc matrix2fc, float f) {
        if (this == matrix2fc) {
            return true;
        }
        if (matrix2fc == null) {
            return false;
        }
        if (!(matrix2fc instanceof Matrix2f)) {
            return false;
        }
        if (!Runtime.equals(this.m00, matrix2fc.m00(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m01, matrix2fc.m01(), f)) {
            return false;
        }
        if (!Runtime.equals(this.m10, matrix2fc.m10(), f)) {
            return false;
        }
        return Runtime.equals(this.m11, matrix2fc.m11(), f);
    }

    public Matrix2f swap(Matrix2f matrix2f) {
        MemUtil.INSTANCE.swap(this, matrix2f);
        return this;
    }

    public Matrix2f add(Matrix2fc matrix2fc) {
        return this.add(matrix2fc, this);
    }

    @Override
    public Matrix2f add(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 + matrix2fc.m00();
        matrix2f.m01 = this.m01 + matrix2fc.m01();
        matrix2f.m10 = this.m10 + matrix2fc.m10();
        matrix2f.m11 = this.m11 + matrix2fc.m11();
        return matrix2f;
    }

    public Matrix2f sub(Matrix2fc matrix2fc) {
        return this.sub(matrix2fc, this);
    }

    @Override
    public Matrix2f sub(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 - matrix2fc.m00();
        matrix2f.m01 = this.m01 - matrix2fc.m01();
        matrix2f.m10 = this.m10 - matrix2fc.m10();
        matrix2f.m11 = this.m11 - matrix2fc.m11();
        return matrix2f;
    }

    public Matrix2f mulComponentWise(Matrix2fc matrix2fc) {
        return this.sub(matrix2fc, this);
    }

    @Override
    public Matrix2f mulComponentWise(Matrix2fc matrix2fc, Matrix2f matrix2f) {
        matrix2f.m00 = this.m00 * matrix2fc.m00();
        matrix2f.m01 = this.m01 * matrix2fc.m01();
        matrix2f.m10 = this.m10 * matrix2fc.m10();
        matrix2f.m11 = this.m11 * matrix2fc.m11();
        return matrix2f;
    }

    public Matrix2f lerp(Matrix2fc matrix2fc, float f) {
        return this.lerp(matrix2fc, f, this);
    }

    @Override
    public Matrix2f lerp(Matrix2fc matrix2fc, float f, Matrix2f matrix2f) {
        matrix2f.m00 = Math.fma(matrix2fc.m00() - this.m00, f, this.m00);
        matrix2f.m01 = Math.fma(matrix2fc.m01() - this.m01, f, this.m01);
        matrix2f.m10 = Math.fma(matrix2fc.m10() - this.m10, f, this.m10);
        matrix2f.m11 = Math.fma(matrix2fc.m11() - this.m11, f, this.m11);
        return matrix2f;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.m00) && Math.isFinite(this.m01) && Math.isFinite(this.m10) && Math.isFinite(this.m11);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

