/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.darkhax.enchdesc.jei.CategoryEnchantmentInfo;
import net.darkhax.enchdesc.jei.EnchantmentInfoEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class EnchDescJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("enchdesc", "jei");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42100_), new ResourceLocation[]{CategoryEnchantmentInfo.ID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42690_), new ResourceLocation[]{CategoryEnchantmentInfo.ID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<EnchantmentInfoEntry> recipes = ForgeRegistries.ENCHANTMENTS.getValues().stream().map(EnchantmentInfoEntry::new).collect(Collectors.toList());
        registration.addRecipes(recipes, CategoryEnchantmentInfo.ID);
        recipes.forEach(i -> registration.addIngredientInfo(i.getBooks(), VanillaTypes.ITEM, new Component[]{new TranslatableComponent(i.getDescriptionKey())}));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CategoryEnchantmentInfo(registration.getJeiHelpers().getGuiHelper())});
    }
}

