/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.element.window.filter.GuiFilter;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.network.chat.Component;

public abstract class GuiFilterSelect<TILE extends TileEntityMekanism>
extends GuiWindow {
    private static final int FILTER_HEIGHT = 20;
    protected final TILE tile;

    protected GuiFilterSelect(IGuiWrapper gui, TILE tile, int filterCount) {
        super(gui, (gui.getWidth() - 152) / 2, 20, 152, 30 + filterCount * 20, SelectedWindowData.UNSPECIFIED);
        this.tile = tile;
        this.addChild(new GuiElementHolder(gui, 23, this.relativeY + 18, 130, 2 + filterCount * 20));
        int buttonY = this.relativeY + 19;
        buttonY = this.addFilterButton(buttonY, MekanismLang.BUTTON_ITEMSTACK_FILTER, this.getItemStackFilterCreator());
        buttonY = this.addFilterButton(buttonY, MekanismLang.BUTTON_TAG_FILTER, this.getTagFilterCreator());
        buttonY = this.addFilterButton(buttonY, MekanismLang.BUTTON_MATERIAL_FILTER, this.getMaterialFilterCreator());
        this.addFilterButton(buttonY, MekanismLang.BUTTON_MODID_FILTER, this.getModIDFilterCreator());
    }

    private int addFilterButton(int buttonY, ILangEntry translationHelper, @Nullable GuiFilterCreator<TILE> filterSupplier) {
        if (filterSupplier == null) {
            return buttonY;
        }
        this.addChild(new TranslationButton(this.gui(), 24, buttonY, 128, 20, translationHelper, () -> {
            this.gui().addWindow(filterSupplier.create(this.gui(), this.tile));
            this.close();
        }));
        return buttonY + 20;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getItemStackFilterCreator() {
        return null;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getTagFilterCreator() {
        return null;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getMaterialFilterCreator() {
        return null;
    }

    @Nullable
    protected GuiFilterCreator<TILE> getModIDFilterCreator() {
        return null;
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawTitleText(matrix, (Component)MekanismLang.CREATE_FILTER_TITLE.translate(new Object[0]), 6.0f);
    }

    @FunctionalInterface
    protected static interface GuiFilterCreator<TILE extends TileEntityMekanism> {
        public GuiFilter<?, ?> create(IGuiWrapper var1, TILE var2);
    }
}

