/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.Mekanism;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ModelEnergyCube
extends MekanismJavaModel {
    public static final ModelLayerLocation CUBE_LAYER = new ModelLayerLocation(Mekanism.rl("energy_cube"), "main");
    private static final ResourceLocation CUBE_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube.png");
    private static final ResourceLocation OVERLAY_ON = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube_overlay_on.png");
    private static final ResourceLocation OVERLAY_OFF = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube_overlay_off.png");
    private static final ResourceLocation BASE_OVERLAY = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube_overlay_base.png");
    private static final RenderType RENDER_TYPE_ON = MekanismRenderType.standard(OVERLAY_ON);
    private static final RenderType RENDER_TYPE_OFF = MekanismRenderType.standard(OVERLAY_OFF);
    private static final RenderType RENDER_TYPE_BASE = MekanismRenderType.standard(BASE_OVERLAY);
    private static final ModelPartData FRAME_12 = new ModelPartData("frame12", CubeListBuilder.m_171558_().m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)-8.0f, (float)11.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_11 = new ModelPartData("frame11", CubeListBuilder.m_171558_().m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_10 = new ModelPartData("frame10", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-5.0f, (float)21.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_9 = new ModelPartData("frame9", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f), PartPose.m_171419_((float)5.0f, (float)21.0f, (float)-5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_8 = new ModelPartData("frame8", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-5.0f, (float)8.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_7 = new ModelPartData("frame7", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-5.0f, (float)21.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_6 = new ModelPartData("frame6", CubeListBuilder.m_171558_().m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_5 = new ModelPartData("frame5", CubeListBuilder.m_171558_().m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f), PartPose.m_171419_((float)-8.0f, (float)11.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_4 = new ModelPartData("frame4", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f), PartPose.m_171419_((float)5.0f, (float)8.0f, (float)-5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_3 = new ModelPartData("frame3", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f), PartPose.m_171419_((float)-8.0f, (float)21.0f, (float)-5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_2 = new ModelPartData("frame2", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)-5.0f), new ModelPartData[0]);
    private static final ModelPartData FRAME_1 = new ModelPartData("frame1", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-5.0f, (float)8.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_8 = new ModelPartData("corner8", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)21.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_7 = new ModelPartData("corner7", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)21.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_6 = new ModelPartData("corner6", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-8.0f, (float)21.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_5 = new ModelPartData("corner5", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-8.0f, (float)21.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_4 = new ModelPartData("corner4", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)8.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_3 = new ModelPartData("corner3", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)5.0f, (float)8.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_2 = new ModelPartData("corner2", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)5.0f), new ModelPartData[0]);
    private static final ModelPartData CORNER_1 = new ModelPartData("corner1", CubeListBuilder.m_171558_().m_171514_(26, 13).m_171481_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTOR_BACK_TOGGLE = new ModelPartData("connectorBackToggle", CubeListBuilder.m_171558_().m_171514_(38, 16).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-5.0f, (float)13.0f, (float)6.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTOR_RIGHT_TOGGLE = new ModelPartData("connectorRightToggle", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 10.0f), PartPose.m_171419_((float)6.0f, (float)13.0f, (float)-5.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTOR_BOTTOM_TOGGLE = new ModelPartData("connectorBottomToggle", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-5.0f, (float)22.0f, (float)-3.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTOR_LEFT_TOGGLE = new ModelPartData("connectorLeftToggle", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 10.0f), PartPose.m_171419_((float)-7.0f, (float)13.0f, (float)-5.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTOR_FRONT_TOGGLE = new ModelPartData("connectorFrontToggle", CubeListBuilder.m_171558_().m_171514_(38, 16).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-5.0f, (float)13.0f, (float)-7.0f), new ModelPartData[0]);
    private static final ModelPartData CONNECTOR_TOP_TOGGLE = new ModelPartData("connectorTopToggle", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-5.0f, (float)9.0f, (float)-3.0f), new ModelPartData[0]);
    private static final ModelPartData PORT_BACK_TOGGLE = new ModelPartData("portBackToggle", CubeListBuilder.m_171558_().m_171514_(18, 35).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 1.0f), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)7.0f), new ModelPartData[0]);
    private static final ModelPartData PORT_BOTTOM_TOGGLE = new ModelPartData("portBottomToggle", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 8.0f), PartPose.m_171419_((float)-4.0f, (float)23.0f, (float)-4.0f), new ModelPartData[0]);
    private static final ModelPartData PORT_FRONT_TOGGLE = new ModelPartData("portFrontToggle", CubeListBuilder.m_171558_().m_171514_(18, 35).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 1.0f), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)-8.0f), new ModelPartData[0]);
    private static final ModelPartData PORT_LEFT_TOGGLE = new ModelPartData("portLeftToggle", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 8.0f), PartPose.m_171419_((float)-8.0f, (float)12.0f, (float)-4.0f), new ModelPartData[0]);
    private static final ModelPartData PORT_RIGHT_TOGGLE = new ModelPartData("portRightToggle", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 8.0f), PartPose.m_171419_((float)7.0f, (float)12.0f, (float)-4.0f), new ModelPartData[0]);
    private static final ModelPartData PORT_TOP_TOGGLE = new ModelPartData("portTopToggle", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 8.0f), PartPose.m_171419_((float)-4.0f, (float)8.0f, (float)-4.0f), new ModelPartData[0]);
    private static final ModelPartData LED_TOP_1 = new ModelPartData("ledTop1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-5.5f, (float)8.1f, (float)-0.5f), new ModelPartData[0]);
    private static final ModelPartData LED_TOP_2 = new ModelPartData("ledTop2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)4.5f, (float)8.1f, (float)-0.5f), new ModelPartData[0]);
    private static final ModelPartData LED_BACK_1 = new ModelPartData("ledBack1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-5.5f, (float)15.5f, (float)6.9f), new ModelPartData[0]);
    private static final ModelPartData LED_BACK_2 = new ModelPartData("ledBack2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)4.5f, (float)15.5f, (float)6.9f), new ModelPartData[0]);
    private static final ModelPartData LED_BOTTOM_2 = new ModelPartData("ledBottom2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)4.5f, (float)22.9f, (float)-0.5f), new ModelPartData[0]);
    private static final ModelPartData LED_BOTTOM_1 = new ModelPartData("ledBottom1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-5.5f, (float)22.9f, (float)-0.5f), new ModelPartData[0]);
    private static final ModelPartData LED_FRONT_1 = new ModelPartData("ledFront1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-5.5f, (float)15.5f, (float)-7.9f), new ModelPartData[0]);
    private static final ModelPartData LED_FRONT_2 = new ModelPartData("ledFront2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)4.5f, (float)15.5f, (float)-7.9f), new ModelPartData[0]);
    private static final ModelPartData LED_RIGHT_2 = new ModelPartData("ledRight2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)6.9f, (float)15.5f, (float)4.5f), new ModelPartData[0]);
    private static final ModelPartData LED_RIGHT_1 = new ModelPartData("ledRight1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)6.9f, (float)15.5f, (float)-5.5f), new ModelPartData[0]);
    private static final ModelPartData LED_LEFT_1 = new ModelPartData("ledLeft1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-7.9f, (float)15.5f, (float)4.5f), new ModelPartData[0]);
    private static final ModelPartData LED_LEFT_2 = new ModelPartData("ledLeft2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-7.9f, (float)15.5f, (float)-5.5f), new ModelPartData[0]);
    private final RenderType RENDER_TYPE = this.m_103119_(CUBE_TEXTURE);
    private final List<ModelPart> frame;
    private final List<ModelPart> corners;
    private final List<ModelPart> leds1;
    private final List<ModelPart> leds2;
    private final List<ModelPart> ports;
    private final List<ModelPart> connectors;

    public static LayerDefinition createLayerDefinition() {
        return ModelEnergyCube.createLayerDefinition(64, 64, FRAME_12, FRAME_11, FRAME_10, FRAME_9, FRAME_8, FRAME_7, FRAME_6, FRAME_5, FRAME_4, FRAME_3, FRAME_2, FRAME_1, CORNER_8, CORNER_7, CORNER_6, CORNER_5, CORNER_4, CORNER_3, CORNER_2, CORNER_1, CONNECTOR_BACK_TOGGLE, CONNECTOR_RIGHT_TOGGLE, CONNECTOR_BOTTOM_TOGGLE, CONNECTOR_LEFT_TOGGLE, CONNECTOR_FRONT_TOGGLE, CONNECTOR_TOP_TOGGLE, PORT_BACK_TOGGLE, PORT_BOTTOM_TOGGLE, PORT_FRONT_TOGGLE, PORT_LEFT_TOGGLE, PORT_RIGHT_TOGGLE, PORT_TOP_TOGGLE, LED_TOP_1, LED_TOP_2, LED_BACK_1, LED_BACK_2, LED_BOTTOM_2, LED_BOTTOM_1, LED_FRONT_1, LED_FRONT_2, LED_RIGHT_2, LED_RIGHT_1, LED_LEFT_1, LED_LEFT_2);
    }

    public ModelEnergyCube(EntityModelSet entityModelSet) {
        super(RenderType::m_110446_);
        ModelPart root = entityModelSet.m_171103_(CUBE_LAYER);
        this.frame = ModelEnergyCube.getRenderableParts(root, FRAME_12, FRAME_11, FRAME_10, FRAME_9, FRAME_8, FRAME_7, FRAME_6, FRAME_5, FRAME_4, FRAME_3, FRAME_2, FRAME_1);
        this.corners = ModelEnergyCube.getRenderableParts(root, CORNER_8, CORNER_7, CORNER_6, CORNER_5, CORNER_4, CORNER_3, CORNER_2, CORNER_1);
        this.leds1 = ModelEnergyCube.getRenderableParts(root, LED_FRONT_1, LED_LEFT_1, LED_RIGHT_1, LED_BACK_1, LED_TOP_1, LED_BOTTOM_1);
        this.leds2 = ModelEnergyCube.getRenderableParts(root, LED_FRONT_2, LED_LEFT_2, LED_RIGHT_2, LED_BACK_2, LED_TOP_2, LED_BOTTOM_2);
        this.ports = ModelEnergyCube.getRenderableParts(root, PORT_FRONT_TOGGLE, PORT_LEFT_TOGGLE, PORT_RIGHT_TOGGLE, PORT_BACK_TOGGLE, PORT_TOP_TOGGLE, PORT_BOTTOM_TOGGLE);
        this.connectors = ModelEnergyCube.getRenderableParts(root, CONNECTOR_FRONT_TOGGLE, CONNECTOR_LEFT_TOGGLE, CONNECTOR_RIGHT_TOGGLE, CONNECTOR_BACK_TOGGLE, CONNECTOR_TOP_TOGGLE, CONNECTOR_BOTTOM_TOGGLE);
    }

    public void render(@Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight, EnergyCubeTier tier, boolean renderMain, boolean hasEffect) {
        if (renderMain) {
            this.m_7695_(matrix, ModelEnergyCube.getVertexConsumer(renderer, this.RENDER_TYPE, hasEffect), light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        EnumColor color = tier.getBaseTier().getColor();
        this.renderCorners(matrix, ModelEnergyCube.getVertexConsumer(renderer, RENDER_TYPE_BASE, hasEffect), 0xF000F0, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), 1.0f);
    }

    public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha) {
        ModelEnergyCube.renderPartsToBuffer(this.frame, poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        ModelEnergyCube.renderPartsToBuffer(this.corners, poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
    }

    private void renderCorners(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int light, int overlayLight, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.001f, 1.005f, 1.001f);
        poseStack.m_85837_(0.0, -0.0061, 0.0);
        ModelEnergyCube.renderPartsToBuffer(this.corners, poseStack, vertexConsumer, light, overlayLight, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public void renderSidesBatched(@Nonnull TileEntityEnergyCube tile, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight) {
        EnumSet<RelativeSide> enabledSides = EnumSet.noneOf(RelativeSide.class);
        EnumSet<RelativeSide> outputSides = EnumSet.noneOf(RelativeSide.class);
        ConfigInfo config = tile.getConfig().getConfig(TransmissionType.ENERGY);
        if (config != null) {
            for (RelativeSide side : EnumUtils.SIDES) {
                ISlotInfo slotInfo = config.getSlotInfo(side);
                if (slotInfo == null) continue;
                if (slotInfo.canInput()) {
                    enabledSides.add(side);
                    continue;
                }
                if (!slotInfo.canOutput()) continue;
                enabledSides.add(side);
                outputSides.add(side);
            }
        }
        this.renderSidesBatched(matrix, renderer, light, overlayLight, enabledSides, outputSides, false);
    }

    public void renderSidesBatched(@Nonnull ItemStack stack, EnergyCubeTier tier, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight, boolean hasEffect) {
        Set<RelativeSide> outputSides;
        EnumSet<RelativeSide> enabledSides;
        CompoundTag configData = ItemDataUtils.getDataMapIfPresent(stack);
        if (configData != null && configData.m_128425_("componentConfig", 10)) {
            enabledSides = EnumSet.noneOf(RelativeSide.class);
            outputSides = EnumSet.noneOf(RelativeSide.class);
            CompoundTag sideConfig = configData.m_128469_("componentConfig").m_128469_("config" + TransmissionType.ENERGY.ordinal());
            for (RelativeSide side : EnumUtils.SIDES) {
                DataType dataType = DataType.byIndexStatic(sideConfig.m_128451_("side" + side.ordinal()));
                if (dataType == DataType.INPUT) {
                    enabledSides.add(side);
                    continue;
                }
                if (dataType != DataType.OUTPUT) continue;
                enabledSides.add(side);
                outputSides.add(side);
            }
        } else {
            enabledSides = EnumSet.allOf(RelativeSide.class);
            outputSides = tier == EnergyCubeTier.CREATIVE ? EnumSet.allOf(RelativeSide.class) : Collections.singleton(RelativeSide.FRONT);
        }
        this.renderSidesBatched(matrix, renderer, light, overlayLight, enabledSides, outputSides, hasEffect);
    }

    private void renderSidesBatched(@Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight, Set<RelativeSide> enabledSides, Set<RelativeSide> outputSides, boolean hasEffect) {
        if (!enabledSides.isEmpty()) {
            VertexConsumer buffer = ModelEnergyCube.getVertexConsumer(renderer, this.RENDER_TYPE, hasEffect);
            for (RelativeSide enabledSide : enabledSides) {
                int sideOrdinal = enabledSide.ordinal();
                this.connectors.get(sideOrdinal).m_104306_(matrix, buffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
                this.ports.get(sideOrdinal).m_104306_(matrix, buffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!outputSides.isEmpty()) {
                buffer = ModelEnergyCube.getVertexConsumer(renderer, RENDER_TYPE_BASE, hasEffect);
                for (RelativeSide outputSide : outputSides) {
                    this.ports.get(outputSide.ordinal()).m_104306_(matrix, buffer, 0xF000F0, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                this.renderLEDS(outputSides, ModelEnergyCube.getVertexConsumer(renderer, RENDER_TYPE_ON, hasEffect), matrix, 0xF000F0, overlayLight);
            }
        }
        if (outputSides.size() < EnumUtils.SIDES.length) {
            EnumSet<RelativeSide> remainingSides = EnumSet.allOf(RelativeSide.class);
            remainingSides.removeAll(outputSides);
            this.renderLEDS(remainingSides, ModelEnergyCube.getVertexConsumer(renderer, RENDER_TYPE_OFF, hasEffect), matrix, light, overlayLight);
        }
    }

    private void renderLEDS(Set<RelativeSide> sides, VertexConsumer ledBuffer, PoseStack matrix, int light, int overlayLight) {
        for (RelativeSide side : sides) {
            int sideOrdinal = side.ordinal();
            this.leds1.get(sideOrdinal).m_104306_(matrix, ledBuffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
            this.leds2.get(sideOrdinal).m_104306_(matrix, ledBuffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class ModelEnergyCore
    extends MekanismJavaModel {
        public static final ModelLayerLocation CORE_LAYER = new ModelLayerLocation(Mekanism.rl("energy_core"), "main");
        private static final ResourceLocation CORE_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_core.png");
        private static final ModelPartData CUBE = new ModelPartData("cube", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), new ModelPartData[0]);
        private final RenderType RENDER_TYPE = this.m_103119_(CORE_TEXTURE);
        private final ModelPart cube;

        public static LayerDefinition createLayerDefinition() {
            return ModelEnergyCore.createLayerDefinition(32, 32, CUBE);
        }

        public ModelEnergyCore(EntityModelSet entityModelSet) {
            super(MekanismRenderType::standard);
            ModelPart root = entityModelSet.m_171103_(CORE_LAYER);
            this.cube = CUBE.getFromRoot(root);
        }

        public VertexConsumer getBuffer(@Nonnull MultiBufferSource renderer) {
            return renderer.m_6299_(this.RENDER_TYPE);
        }

        public void render(@Nonnull PoseStack matrix, @Nonnull MultiBufferSource renderer, int light, int overlayLight, EnumColor color, float energyPercentage) {
            this.m_7695_(matrix, this.getBuffer(renderer), light, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), energyPercentage);
        }

        public void render(@Nonnull PoseStack matrix, @Nonnull VertexConsumer buffer, int light, int overlayLight, EnumColor color, float energyPercentage) {
            this.cube.m_104306_(matrix, buffer, light, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), energyPercentage);
        }

        public void m_7695_(@Nonnull PoseStack matrix, @Nonnull VertexConsumer vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
            this.cube.m_104306_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        }
    }
}

