/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.lib.Color;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public interface QuadTransformation {
    public static final Direction[][] ROTATION_MATRIX = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN}, {Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.UP, Direction.UP, Direction.UP}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.WEST, Direction.WEST, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}, {Direction.EAST, Direction.EAST, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}};
    public static final QuadTransformation identity = q -> {};
    public static final QuadTransformation fullbright = QuadTransformation.light(1.0f);
    public static final QuadTransformation filtered_fullbright = TextureFilteredTransformation.of(fullbright, rl -> rl.m_135815_().contains("led"));

    public static QuadTransformation color(Color color) {
        return new ColorTransformation(color);
    }

    public static QuadTransformation light(float light) {
        return new LightTransformation(light, light);
    }

    public static QuadTransformation translate(Vec3 translation) {
        return new TranslationTransformation(translation);
    }

    public static QuadTransformation rotate(Direction side) {
        if (side == null) {
            return identity;
        }
        return switch (side) {
            case Direction.UP -> QuadTransformation.rotate(90.0, 0.0, 0.0);
            case Direction.DOWN -> QuadTransformation.rotate(-90.0, 0.0, 0.0);
            case Direction.WEST -> QuadTransformation.rotate(0.0, 90.0, 0.0);
            case Direction.EAST -> QuadTransformation.rotate(0.0, -90.0, 0.0);
            case Direction.SOUTH -> QuadTransformation.rotate(0.0, 180.0, 0.0);
            default -> identity;
        };
    }

    public static QuadTransformation rotateY(double degrees) {
        return QuadTransformation.rotate(0.0, degrees, 0.0);
    }

    public static QuadTransformation rotate(double rotationX, double rotationY, double rotationZ) {
        return QuadTransformation.rotate(new Quaternion(rotationX, rotationY, rotationZ, true));
    }

    public static QuadTransformation rotate(Quaternion quat) {
        return new RotationTransformation(quat);
    }

    public static QuadTransformation sideRotate(Direction side) {
        return new SideTransformation(side);
    }

    public static QuadTransformation texture(TextureAtlasSprite texture) {
        return new TextureTransformation(texture);
    }

    public static QuadTransformation list(QuadTransformation ... transforms) {
        return TransformationList.of(transforms);
    }

    public void transform(Quad var1);

    default public QuadTransformation and(QuadTransformation other) {
        return QuadTransformation.list(this, other);
    }

    public static class ColorTransformation
    implements QuadTransformation {
        private final Color color;

        protected ColorTransformation(Color color) {
            this.color = color;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> v.color(this.color));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof ColorTransformation)) return false;
            ColorTransformation other = (ColorTransformation)o;
            if (!this.color.equals(other.color)) return false;
            return true;
        }

        public int hashCode() {
            return this.color.hashCode();
        }
    }

    public static class LightTransformation
    implements QuadTransformation {
        private final float lightU;
        private final float lightV;

        public LightTransformation(float lightU, float lightV) {
            this.lightU = lightU;
            this.lightV = lightV;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> v.light(this.lightU, this.lightV));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof LightTransformation)) return false;
            LightTransformation other = (LightTransformation)o;
            if (this.lightU != other.lightU) return false;
            if (this.lightV != other.lightV) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.lightU), Float.valueOf(this.lightV));
        }
    }

    public static class TranslationTransformation
    implements QuadTransformation {
        private final Vec3 translation;

        protected TranslationTransformation(Vec3 translation) {
            this.translation = translation;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> v.pos(v.getPos().m_82549_(this.translation)));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof TranslationTransformation)) return false;
            TranslationTransformation other = (TranslationTransformation)o;
            if (!this.translation.equals((Object)other.translation)) return false;
            return true;
        }

        public int hashCode() {
            return this.translation.hashCode();
        }
    }

    public static class RotationTransformation
    implements QuadTransformation {
        private static final double EPSILON = 10000.0;
        private final Quaternion quaternion;

        protected RotationTransformation(Quaternion quaternion) {
            this.quaternion = quaternion;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> {
                v.pos(RotationTransformation.round(this.quaternion.rotate(v.getPos().m_82492_(0.5, 0.5, 0.5)).m_82520_(0.5, 0.5, 0.5)));
                v.normal(RotationTransformation.round(this.quaternion.rotate(v.getNormal()).normalize()));
            });
        }

        private static Vec3 round(Vec3 vec) {
            return new Vec3((double)Math.round(vec.f_82479_ * 10000.0) / 10000.0, (double)Math.round(vec.f_82480_ * 10000.0) / 10000.0, (double)Math.round(vec.f_82481_ * 10000.0) / 10000.0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof RotationTransformation)) return false;
            RotationTransformation other = (RotationTransformation)o;
            if (!this.quaternion.equals(other.quaternion)) return false;
            return true;
        }

        public int hashCode() {
            return this.quaternion.hashCode();
        }
    }

    public static class SideTransformation
    implements QuadTransformation {
        private final Direction side;

        protected SideTransformation(Direction side) {
            this.side = side;
        }

        @Override
        public void transform(Quad quad) {
            if (this.side != null) {
                quad.setSide(ROTATION_MATRIX[quad.getSide().ordinal()][this.side.ordinal()]);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof SideTransformation)) return false;
            SideTransformation other = (SideTransformation)o;
            if (this.side != other.side) return false;
            return true;
        }

        public int hashCode() {
            return this.side == null ? -1 : this.side.hashCode();
        }
    }

    public static class TextureTransformation
    implements QuadTransformation {
        private final TextureAtlasSprite texture;

        protected TextureTransformation(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        @Override
        public void transform(Quad quad) {
            if (this.texture == null) {
                return;
            }
            QuadUtils.remapUVs(quad, this.texture);
            quad.setTexture(this.texture);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof TextureTransformation)) return false;
            TextureTransformation other = (TextureTransformation)o;
            if (this.texture != other.texture) return false;
            return true;
        }

        public int hashCode() {
            return this.texture == null ? -1 : this.texture.hashCode();
        }
    }

    public static class TransformationList
    implements QuadTransformation {
        private final List<QuadTransformation> list;
        private final int hashCode;

        protected TransformationList(List<QuadTransformation> list) {
            this.list = list;
            this.hashCode = list.hashCode();
        }

        public static TransformationList of(QuadTransformation ... trans) {
            return new TransformationList(List.of(trans));
        }

        @Override
        public void transform(Quad quad) {
            this.list.forEach(transformation -> transformation.transform(quad));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof TransformationList)) return false;
            TransformationList other = (TransformationList)o;
            if (!this.list.equals(other.list)) return false;
            return true;
        }

        @Override
        public QuadTransformation and(QuadTransformation other) {
            ArrayList<QuadTransformation> newList = new ArrayList<QuadTransformation>(this.list);
            newList.add(other);
            return new TransformationList(newList);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class TextureFilteredTransformation
    implements QuadTransformation {
        private final QuadTransformation original;
        private final Predicate<ResourceLocation> verifier;

        protected TextureFilteredTransformation(QuadTransformation original, Predicate<ResourceLocation> verifier) {
            this.original = original;
            this.verifier = verifier;
        }

        public static TextureFilteredTransformation of(QuadTransformation original, Predicate<ResourceLocation> verifier) {
            return new TextureFilteredTransformation(original, verifier);
        }

        @Override
        public void transform(Quad quad) {
            if (this.verifier.test(quad.getTexture().m_118413_())) {
                quad.transform(v -> this.original.transform(quad));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof TextureFilteredTransformation)) return false;
            TextureFilteredTransformation other = (TextureFilteredTransformation)o;
            if (!this.verifier.equals(other.verifier)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.original, this.verifier);
        }
    }
}

