/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.client.sound.PlayerSound;
import mekanism.common.lib.radiation.RadiationManager;
import net.minecraft.world.entity.player.Player;

public class GeigerSound
extends PlayerSound {
    private final RadiationManager.RadiationScale scale;

    public static GeigerSound create(@Nonnull Player player, RadiationManager.RadiationScale scale) {
        if (scale == RadiationManager.RadiationScale.NONE) {
            throw new IllegalArgumentException("Can't create a GeigerSound with a RadiationScale of NONE.");
        }
        int subtitleFrequency = scale == RadiationManager.RadiationScale.MEDIUM ? 50 : (scale == RadiationManager.RadiationScale.ELEVATED ? 40 : (scale == RadiationManager.RadiationScale.HIGH ? 30 : (scale == RadiationManager.RadiationScale.EXTREME ? 20 : 60)));
        return new GeigerSound(player, scale, subtitleFrequency);
    }

    private GeigerSound(@Nonnull Player player, RadiationManager.RadiationScale scale, int subtitleFrequency) {
        super(player, Objects.requireNonNull(scale.getSoundEvent()), subtitleFrequency);
        this.scale = scale;
        this.setFade(1.0f, 1.0f);
    }

    @Override
    public boolean shouldPlaySound(@Nonnull Player player) {
        return this.scale == RadiationManager.INSTANCE.getClientScale();
    }

    @Override
    public float m_7769_() {
        return super.m_7769_() * 0.05f;
    }
}

