/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeState;
import mekanism.common.block.states.BlockStateHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AttributeStateActive
implements AttributeState {
    private static final BooleanProperty activeProperty = BooleanProperty.m_61465_((String)"active");
    private final int ambientLight;

    AttributeStateActive(int ambientLight) {
        this.ambientLight = ambientLight;
    }

    @Override
    public boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)activeProperty);
    }

    @Override
    public BlockState setActive(@Nonnull BlockState state, boolean active) {
        return (BlockState)state.m_61124_((Property)activeProperty, (Comparable)Boolean.valueOf(active));
    }

    @Override
    public BlockState copyStateData(BlockState oldState, BlockState newState) {
        if (Attribute.has(newState, AttributeStateActive.class)) {
            newState = (BlockState)newState.m_61124_((Property)activeProperty, (Comparable)((Boolean)oldState.m_61143_((Property)activeProperty)));
        }
        return newState;
    }

    @Override
    public BlockState getDefaultState(@Nonnull BlockState state) {
        return (BlockState)state.m_61124_((Property)activeProperty, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void fillBlockStateContainer(Block block, List<Property<?>> properties) {
        properties.add((Property<?>)activeProperty);
    }

    @Override
    public void adjustProperties(BlockBehaviour.Properties props) {
        if (this.ambientLight > 0) {
            BlockStateHelper.applyLightLevelAdjustments(props, state -> this.isActive((BlockState)state) ? this.ambientLight : 0);
        }
    }
}

