/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import mekanism.common.util.ChemicalUtil;

public class BoxedChemicalTransmitterSaveTarget<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends Target<SaveHandler, Long, STACK> {
    public BoxedChemicalTransmitterSaveTarget(@Nonnull STACK empty, @Nonnull STACK type, Collection<BoxedPressurizedTube> transmitters) {
        super(transmitters.size());
        this.extra = type;
        transmitters.forEach(transmitter -> this.addHandler(new SaveHandler(this, empty, transmitter)));
    }

    @Override
    protected void acceptAmount(SaveHandler handler, SplitInfo<Long> splitInfo, Long amount) {
        handler.acceptAmount(splitInfo, amount);
    }

    @Override
    protected Long simulate(SaveHandler handler, @Nonnull STACK chemicalStack) {
        return handler.simulate(chemicalStack);
    }

    public void saveShare() {
        for (SaveHandler handler : this.handlers) {
            handler.saveShare();
        }
    }

    public static class SaveHandler {
        private STACK currentStored;
        private final BoxedPressurizedTube transmitter;
        final /* synthetic */ BoxedChemicalTransmitterSaveTarget this$0;

        public SaveHandler(STACK empty, BoxedPressurizedTube transmitter) {
            this.this$0 = this$0;
            this.currentStored = empty;
            this.transmitter = transmitter;
        }

        protected void acceptAmount(SplitInfo<Long> splitInfo, Long amount) {
            amount = Math.min(amount, this.transmitter.getCapacity() - ((ChemicalStack)this.currentStored).getAmount());
            if (((ChemicalStack)this.currentStored).isEmpty()) {
                this.currentStored = ChemicalUtil.copyWithAmount((ChemicalStack)this.this$0.extra, amount);
            } else {
                ((ChemicalStack)this.currentStored).grow(amount);
            }
            splitInfo.send(amount);
        }

        protected Long simulate(@Nonnull STACK chemicalStack) {
            if (!((ChemicalStack)this.currentStored).isEmpty() && !((ChemicalStack)this.currentStored).isTypeEqual(chemicalStack)) {
                return 0L;
            }
            return Math.min(((ChemicalStack)chemicalStack).getAmount(), this.transmitter.getCapacity() - ((ChemicalStack)this.currentStored).getAmount());
        }

        protected void saveShare() {
            boolean shouldSave = false;
            if (((ChemicalStack)this.currentStored).isEmpty() != this.transmitter.saveShare.isEmpty()) {
                shouldSave = true;
            } else if (!((ChemicalStack)this.currentStored).isEmpty()) {
                ChemicalType chemicalType = ChemicalType.getTypeFor(this.currentStored);
                boolean bl = shouldSave = chemicalType != this.transmitter.saveShare.getChemicalType() || !((ChemicalStack)this.currentStored).isStackIdentical(this.transmitter.saveShare.getChemicalStack());
            }
            if (shouldSave) {
                this.transmitter.saveShare = ((ChemicalStack)this.currentStored).isEmpty() ? BoxedChemicalStack.EMPTY : BoxedChemicalStack.box(this.currentStored);
                this.transmitter.getTransmitterTile().markForSave();
            }
        }
    }
}

