/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import java.util.List;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.SawmillIRecipe;
import mekanism.common.util.text.TextUtils;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Sawing")
public class SawmillRecipeManager
extends MekanismRecipeManager<SawmillRecipe> {
    public static final SawmillRecipeManager INSTANCE = new SawmillRecipeManager();

    private SawmillRecipeManager() {
        super(MekanismRecipeType.SAWING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, Percentaged<IItemStack> output) {
        this.addRecipe(name, input, (IItemStack)output.getData(), output.getPercentage());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack output, double chance) {
        if (chance < 1.0) {
            this.addRecipe(name, input, ItemStack.f_41583_, this.getAndValidateNotEmpty(output), this.getAndValidateSecondaryChance(chance));
        } else if (chance == 1.0) {
            this.addRecipe(name, input, this.getAndValidateNotEmpty(output), ItemStack.f_41583_, 0.0);
        } else if (chance < 2.0) {
            ItemStack stack = this.getAndValidateNotEmpty(output);
            this.addRecipe(name, input, stack, stack.m_41777_(), this.getAndValidateSecondaryChance(chance - 1.0));
        } else {
            throw new IllegalArgumentException("This sawing recipe should just have the amount increased or explicitly use the two output method.");
        }
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack mainOutput, Percentaged<IItemStack> secondaryOutput) {
        this.addRecipe(name, input, mainOutput, (IItemStack)secondaryOutput.getData(), secondaryOutput.getPercentage());
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack mainOutput, IItemStack secondaryOutput, double secondaryChance) {
        this.addRecipe(name, input, this.getAndValidateNotEmpty(mainOutput), this.getAndValidateNotEmpty(secondaryOutput), this.getAndValidateSecondaryChance(secondaryChance));
    }

    private void addRecipe(String name, ItemStackIngredient input, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance) {
        this.addRecipe(new SawmillIRecipe(this.getAndValidateName(name), input, mainOutput, secondaryOutput, secondaryChance));
    }

    private double getAndValidateSecondaryChance(double secondaryChance) {
        if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("This sawing recipe requires a secondary output chance greater than zero and at most one.");
        }
        return secondaryChance;
    }

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(SawmillRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                StringBuilder builder = new StringBuilder();
                List<ItemStack> mainOutputs = ((SawmillRecipe)this.recipe).getMainOutputDefinition();
                if (!mainOutputs.isEmpty()) {
                    builder.append("main: ").append(CrTUtils.describeOutputs(mainOutputs, ItemStackUtil::getCommandString));
                }
                if (((SawmillRecipe)this.recipe).getSecondaryChance() > 0.0) {
                    if (!mainOutputs.isEmpty()) {
                        builder.append("; ");
                    }
                    if (((SawmillRecipe)this.recipe).getSecondaryChance() == 1.0) {
                        builder.append("secondary: ");
                    } else {
                        builder.append("secondary with chance ").append(TextUtils.getPercent(((SawmillRecipe)this.recipe).getSecondaryChance())).append(": ");
                    }
                    builder.append(CrTUtils.describeOutputs(((SawmillRecipe)this.recipe).getSecondaryOutputDefinition(), ItemStackUtil::getCommandString));
                }
                return builder.toString();
            }
        };
    }
}

