/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.IModuleItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemModule
extends Item
implements IModuleItem {
    private final IModuleDataProvider<?> moduleData;

    public ItemModule(IModuleDataProvider<?> moduleData, Item.Properties properties) {
        super(properties);
        this.moduleData = moduleData;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getModuleData().getMaxStackSize();
    }

    @Override
    public ModuleData<?> getModuleData() {
        return this.moduleData.getModuleData();
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return this.getModuleData().getRarity();
    }

    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            tooltip.add((Component)MekanismLang.MODULE_SUPPORTED.translateColored(EnumColor.BRIGHT_GREEN, new Object[0]));
            IModuleHelper moduleHelper = MekanismAPI.getModuleHelper();
            for (Item item : moduleHelper.getSupported(this.getModuleData())) {
                tooltip.add((Component)MekanismLang.GENERIC_LIST.translate(item.m_7626_(new ItemStack((ItemLike)item))));
            }
            Set<ModuleData<?>> conflicting = moduleHelper.getConflicting(this.getModuleData());
            if (!conflicting.isEmpty()) {
                tooltip.add((Component)MekanismLang.MODULE_CONFLICTING.translateColored(EnumColor.RED, new Object[0]));
                for (ModuleData<?> module : conflicting) {
                    tooltip.add((Component)MekanismLang.GENERIC_LIST.translate(module));
                }
            }
        } else {
            ModuleData<?> moduleData = this.getModuleData();
            tooltip.add((Component)TextComponentUtil.translate(moduleData.getDescriptionTranslationKey(), new Object[0]));
            tooltip.add((Component)MekanismLang.MODULE_STACKABLE.translateColored(EnumColor.GRAY, EnumColor.AQUA, moduleData.getMaxStackSize()));
            tooltip.add((Component)MekanismLang.HOLD_FOR_SUPPORTED_ITEMS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()));
        }
    }

    @Nonnull
    public String m_5524_() {
        return this.getModuleData().getTranslationKey();
    }
}

