/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.item.ItemEnergized;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemNetworkReader
extends ItemEnergized {
    public ItemNetworkReader(Item.Properties properties) {
        super(MekanismConfig.gear.networkReaderChargeRate, MekanismConfig.gear.networkReaderMaxEnergy, properties.m_41497_(Rarity.UNCOMMON));
    }

    private void displayBorder(Player player, Object toDisplay, boolean brackets) {
        player.m_6352_((Component)MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "-------------", EnumColor.DARK_BLUE, brackets ? MekanismLang.GENERIC_SQUARE_BRACKET.translate(toDisplay) : toDisplay), Util.f_137441_);
    }

    private void displayEndBorder(Player player) {
        this.displayBorder(player, "[=======]", false);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (!world.f_46443_ && player != null) {
            BlockPos pos = context.m_8083_();
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            if (tile != null) {
                if (!player.m_7500_()) {
                    FloatingLong energyPerUse = (FloatingLong)MekanismConfig.gear.networkReaderEnergyUsage.get();
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(context.m_43722_(), 0);
                    if (energyContainer == null || energyContainer.extract(energyPerUse, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerUse)) {
                        return InteractionResult.FAIL;
                    }
                    energyContainer.extract(energyPerUse, Action.EXECUTE, AutomationType.MANUAL);
                }
                Direction opposite = context.m_43719_().m_122424_();
                if (tile instanceof TileEntityTransmitter) {
                    TileEntityTransmitter transmitterTile = (TileEntityTransmitter)tile;
                    this.displayTransmitterInfo(player, transmitterTile.getTransmitter(), tile, opposite);
                } else {
                    Optional heatHandler = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_HANDLER_CAPABILITY, opposite).resolve();
                    if (heatHandler.isPresent()) {
                        IHeatHandler transfer = (IHeatHandler)heatHandler.get();
                        this.displayBorder(player, MekanismLang.MEKANISM, true);
                        this.sendTemperature(player, transfer);
                        this.displayEndBorder(player);
                    } else {
                        this.displayConnectedNetworks(player, world, pos);
                    }
                }
                return InteractionResult.CONSUME;
            }
            if (player.m_6144_() && MekanismAPI.debug) {
                this.displayBorder(player, MekanismLang.DEBUG_TITLE, true);
                for (Component component : TransmitterNetworkRegistry.getInstance().toComponents()) {
                    player.m_6352_((Component)TextComponentUtil.build(EnumColor.DARK_GRAY, component), Util.f_137441_);
                }
                this.displayEndBorder(player);
            }
        }
        return InteractionResult.PASS;
    }

    private void displayTransmitterInfo(Player player, Transmitter<?, ?, ?> transmitter, BlockEntity tile, Direction opposite) {
        this.displayBorder(player, MekanismLang.MEKANISM, true);
        if (transmitter.hasTransmitterNetwork()) {
            Object transmitterNetwork = transmitter.getTransmitterNetwork();
            player.m_6352_((Component)MekanismLang.NETWORK_READER_TRANSMITTERS.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, ((DynamicNetwork)transmitterNetwork).transmittersSize()), Util.f_137441_);
            player.m_6352_((Component)MekanismLang.NETWORK_READER_ACCEPTORS.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, ((DynamicNetwork)transmitterNetwork).getAcceptorCount()), Util.f_137441_);
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_NEEDED, transmitterNetwork.getNeededInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_BUFFER, transmitterNetwork.getStoredInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_THROUGHPUT, transmitterNetwork.getFlowInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_CAPACITY, transmitterNetwork.getNetworkReaderCapacity());
            CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_HANDLER_CAPABILITY, opposite).ifPresent(heatHandler -> this.sendTemperature(player, (IHeatHandler)heatHandler));
        } else {
            player.m_6352_((Component)MekanismLang.NO_NETWORK.translate(new Object[0]), Util.f_137441_);
        }
        this.displayEndBorder(player);
    }

    private void displayConnectedNetworks(Player player, Level world, BlockPos pos) {
        ObjectOpenHashSet iteratedNetworks = new ObjectOpenHashSet();
        for (Direction side : EnumUtils.DIRECTIONS) {
            TileEntityTransmitter transmitterTile;
            Transmitter<?, ?, ?> transmitter;
            Object transmitterNetwork;
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos.m_142300_(side));
            if (!(tile instanceof TileEntityTransmitter) || !((DynamicNetwork)(transmitterNetwork = (transmitter = (transmitterTile = (TileEntityTransmitter)tile).getTransmitter()).getTransmitterNetwork())).hasAcceptor(pos) || iteratedNetworks.contains(transmitterNetwork)) continue;
            this.displayBorder(player, this.compileList(transmitter.getSupportedTransmissionTypes()), false);
            player.m_6352_((Component)MekanismLang.NETWORK_READER_CONNECTED_SIDES.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, this.compileList(((DynamicNetwork)transmitterNetwork).getAcceptorDirections(pos))), Util.f_137441_);
            this.displayEndBorder(player);
            iteratedNetworks.add(transmitterNetwork);
        }
    }

    private void sendTemperature(Player player, IHeatHandler handler) {
        Component temp = MekanismUtils.getTemperatureDisplay(handler.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
        player.m_6352_((Component)MekanismLang.NETWORK_READER_TEMPERATURE.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, temp), Util.f_137441_);
    }

    private void sendMessageIfNonNull(Player player, ILangEntry langEntry, Object toSend) {
        if (toSend != null) {
            player.m_6352_((Component)langEntry.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, toSend), Util.f_137441_);
        }
    }

    private <ENUM extends Enum<ENUM>> Component compileList(Set<ENUM> elements) {
        if (elements.isEmpty()) {
            return MekanismLang.GENERIC_SQUARE_BRACKET.translate("");
        }
        MutableComponent component = null;
        for (Enum element : elements) {
            if (component == null) {
                component = TextComponentUtil.build(element);
                continue;
            }
            component = MekanismLang.GENERIC_WITH_COMMA.translate(component, element);
        }
        return MekanismLang.GENERIC_SQUARE_BRACKET.translate(component);
    }
}

