/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketRadiationData
implements IMekanismPacket {
    private final RadiationPacketType type;
    private final double radiation;

    private PacketRadiationData(RadiationPacketType type, double radiation) {
        this.type = type;
        this.radiation = radiation;
    }

    public static PacketRadiationData createEnvironmental(double radiation) {
        return new PacketRadiationData(RadiationPacketType.ENVIRONMENTAL, radiation);
    }

    public static void sync(ServerPlayer player) {
        player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> Mekanism.packetHandler().sendTo(new PacketRadiationData(RadiationPacketType.PLAYER, c.getRadiation()), player));
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player;
        if (this.type == RadiationPacketType.ENVIRONMENTAL) {
            RadiationManager.INSTANCE.setClientEnvironmentalRadiation(this.radiation);
        } else if (this.type == RadiationPacketType.PLAYER && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.getCapability(Capabilities.RADIATION_ENTITY_CAPABILITY).ifPresent(c -> c.set(this.radiation));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        buffer.writeDouble(this.radiation);
    }

    public static PacketRadiationData decode(FriendlyByteBuf buffer) {
        return new PacketRadiationData((RadiationPacketType)buffer.m_130066_(RadiationPacketType.class), buffer.readDouble());
    }

    public static enum RadiationPacketType {
        ENVIRONMENTAL,
        PLAYER;

    }
}

