/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class GasToGasRecipeSerializer<RECIPE extends GasToGasRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public GasToGasRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)input);
        GasStack output = SerializerHelper.getGasStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, inputIngredient, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            GasStack output = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, inputIngredient, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading gas to gas recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((ChemicalToChemicalRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing gas to gas recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends GasToGasRecipe> {
        public RECIPE create(ResourceLocation var1, ChemicalStackIngredient.GasStackIngredient var2, GasStack var3);
    }
}

