/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnergyDisplay
implements IHasTextComponent {
    public static final EnergyDisplay ZERO = EnergyDisplay.of(FloatingLong.ZERO);
    private final FloatingLong energy;
    private final FloatingLong max;

    private EnergyDisplay(FloatingLong energy, FloatingLong max) {
        this.energy = energy;
        this.max = max;
    }

    public static EnergyDisplay of(IEnergyContainer container) {
        return EnergyDisplay.of(container.getEnergy(), container.getMaxEnergy());
    }

    public static EnergyDisplay of(FloatingLong energy, FloatingLong max) {
        return new EnergyDisplay(energy, max);
    }

    public static EnergyDisplay of(FloatingLong energy) {
        return EnergyDisplay.of(energy, FloatingLong.ZERO);
    }

    @Override
    public Component getTextComponent() {
        if (this.energy.equals(FloatingLong.MAX_VALUE)) {
            return MekanismLang.INFINITE.translate(new Object[0]);
        }
        if (this.max.isZero()) {
            return MekanismUtils.getEnergyDisplayShort(this.energy);
        }
        return MekanismLang.GENERIC_FRACTION.translate(MekanismUtils.getEnergyDisplayShort(this.energy), EnergyDisplay.of(this.max));
    }
}

