/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.TooltipHandler;
import mcp.mobius.waila.gui.screen.HomeScreen;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.IClientService;
import net.minecraft.class_1799;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public abstract class WailaClient {
    public static boolean showComponentBounds = false;
    public static class_304 keyOpenConfig;
    public static class_304 keyShowOverlay;
    public static class_304 keyToggleLiquid;
    public static class_304 keyShowRecipeInput;
    public static class_304 keyShowRecipeOutput;
    public static Runnable onShowRecipeInput;
    public static Runnable onShowRecipeOutput;

    protected static void registerKeyBinds() {
        keyOpenConfig = WailaClient.createKeyBind("config");
        keyShowOverlay = WailaClient.createKeyBind("show_overlay");
        keyToggleLiquid = WailaClient.createKeyBind("toggle_liquid");
        keyShowRecipeInput = WailaClient.createKeyBind("show_recipe_input");
        keyShowRecipeOutput = WailaClient.createKeyBind("show_recipe_output");
    }

    protected static void onClientTick() {
        class_310 client = class_310.method_1551();
        WailaConfig config = Waila.CONFIG.get();
        TooltipHandler.tick();
        while (keyOpenConfig.method_1436()) {
            client.method_1507((class_437)new HomeScreen(null));
        }
        while (keyShowOverlay.method_1436()) {
            if (config.getGeneral().getDisplayMode() != IWailaConfig.General.DisplayMode.TOGGLE) continue;
            config.getGeneral().setDisplayTooltip(!config.getGeneral().isDisplayTooltip());
        }
        while (keyToggleLiquid.method_1436()) {
            PluginConfig.set(WailaConstants.CONFIG_SHOW_FLUID, !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID));
        }
        while (keyShowRecipeInput.method_1436() && onShowRecipeInput != null) {
            onShowRecipeInput.run();
        }
        while (keyShowRecipeOutput.method_1436() && onShowRecipeOutput != null) {
            onShowRecipeOutput.run();
        }
    }

    protected static void onItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                String name = listener.getHoveredItemModName(stack, PluginConfig.CLIENT);
                if (name == null) continue;
                tooltip.add((class_2561)IWailaConfig.get().getFormatter().modName(name));
                return;
            }
        }
    }

    protected static void onServerLogIn(class_2535 connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    protected static void onServerLogout(class_2535 connection) {
        Waila.BLACKLIST_CONFIG.invalidate();
        PluginConfig.getSyncableConfigs().forEach(config -> config.setServerValue(null));
    }

    private static class_304 createKeyBind(String id) {
        return IClientService.INSTANCE.createKeyBind(id, class_3675.field_16237.method_1444());
    }
}

