/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.GrowingComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.gui.hud.component.DrawableComponent;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class Line
implements ITooltipLine,
class_5250 {
    @Nullable
    public final class_2960 tag;
    public final List<ITooltipComponent> components = new ArrayList<ITooltipComponent>();
    private int width = -1;
    private int height = -1;
    private int growingCount = 0;

    public Line(@Nullable class_2960 tag) {
        this.tag = tag;
    }

    @Override
    public Line with(ITooltipComponent component) {
        this.components.add(component);
        this.height = Math.max(component.getHeight(), this.height);
        if (component instanceof GrowingComponent) {
            ++this.growingCount;
        }
        return this;
    }

    @Override
    public Line with(class_2561 component) {
        ITooltipComponent iTooltipComponent;
        if (component instanceof DrawableComponent) {
            DrawableComponent drawable = (DrawableComponent)component;
            iTooltipComponent = drawable;
        } else {
            iTooltipComponent = new WrappedComponent(component);
        }
        return this.with(iTooltipComponent);
    }

    public void calculateDimension() {
        if (this.width == -1) {
            this.width = this.components.stream().mapToInt(c -> {
                int width = c.getWidth();
                return width > 0 ? width + 1 : 0;
            }).sum();
            if (this.width > 0) {
                --this.width;
            }
        }
        if (this.height == -1) {
            this.height = this.components.stream().mapToInt(ITooltipComponent::getHeight).max().orElse(0);
        }
    }

    public int getWidth() {
        this.assertDimension();
        return this.width;
    }

    public int getHeight() {
        this.assertDimension();
        return this.height;
    }

    public void render(class_4587 matrices, int x, int y, int maxWidth, float delta) {
        this.assertDimension();
        int cx = x;
        int growingWidth = -1;
        for (ITooltipComponent component : this.components) {
            if (component instanceof GrowingComponent) {
                if (growingWidth == -1 && (growingWidth = (maxWidth - this.width) / this.growingCount) % 2 == 1 && this.growingCount > 1) {
                    ++cx;
                }
                cx += growingWidth;
                continue;
            }
            int w = component.getWidth();
            int h = component.getHeight();
            if (w <= 0) continue;
            int cy = y + (h < this.height ? (this.height - h) / 2 : 0);
            DisplayUtil.renderComponent(matrices, component, cx, cy, delta);
            cx += w + 1;
        }
    }

    private void assertDimension() {
        Preconditions.checkState((this.width != -1 && this.height != -1 ? 1 : 0) != 0);
    }

    public class_5250 method_10862(class_2583 style) {
        return this;
    }

    public class_5250 method_10852(class_2561 component) {
        this.with(component);
        return this;
    }

    public class_2583 method_10866() {
        return class_2583.field_24360;
    }

    public String method_10851() {
        return "Line";
    }

    public List<class_2561> method_10855() {
        return Collections.emptyList();
    }

    public class_5250 method_27662() {
        return this;
    }

    public class_5250 method_27661() {
        return this;
    }

    public class_5481 method_30937() {
        return class_5481.field_26385;
    }
}

