/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.config.Theme;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.gui.widget.value.IntInputValue;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_4587;

class ThemeEditorScreen
extends ConfigScreen {
    private final WailaConfigScreen parent;
    private final Theme theme;
    private final boolean edit;
    private final TooltipRenderer.State previewState;
    private InputValue<String> idVal;
    private InputValue<Integer> bgColorVal;
    private InputValue<Integer> gradStartVal;
    private InputValue<Integer> gradEndVal;
    private InputValue<Integer> textColorVal;

    public ThemeEditorScreen(WailaConfigScreen parent, Theme theme, boolean edit) {
        super(parent, class_2585.field_24366, () -> {}, () -> {});
        this.parent = parent;
        this.theme = theme;
        this.edit = edit;
        this.previewState = new PreviewTooltipRendererState();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.parent.buildPreview(this.previewState);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget option = new ConfigListWidget(this, this.field_22787, this.field_22789, this.field_22790, 76, this.field_22790 - 32, 26, () -> {});
        this.idVal = new InputValue<String>("config.waila.overlay_theme_editor.id", this.edit ? this.theme.getId().toString() : "", null, val -> {}, InputValue.IDENTIFIER);
        if (!this.edit) {
            option.add(this.idVal);
        }
        this.bgColorVal = new IntInputValue("config.waila.overlay_theme_editor.background_color", this.theme.getBackgroundColor(), null, val -> {}, IntFormat.RGB_HEX);
        this.gradStartVal = new IntInputValue("config.waila.overlay_theme_editor.gradient_start", this.theme.getGradientStart(), null, val -> {}, IntFormat.RGB_HEX);
        this.gradEndVal = new IntInputValue("config.waila.overlay_theme_editor.gradient_end", this.theme.getGradientEnd(), null, val -> {}, IntFormat.RGB_HEX);
        this.textColorVal = new IntInputValue("config.waila.overlay_theme_editor.text_color", this.theme.getFontColor(), null, val -> {}, IntFormat.RGB_HEX);
        option.with(this.bgColorVal).with(this.gradStartVal).with(this.gradEndVal).with(this.textColorVal);
        if (this.edit && !this.theme.getId().method_12836().equals("waila")) {
            option.add(new ButtonEntry("config.waila.overlay_theme_editor.delete", 100, 20, button -> this.field_22787.method_1507((class_437)new class_410(delete -> {
                if (delete) {
                    this.parent.removeTheme(this.theme.getId());
                    this.field_22787.method_1507((class_437)this.parent);
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)new class_2588("config.waila.overlay_theme_editor.delete_prompt", new Object[]{this.theme.getId()}), class_2585.field_24366))));
        }
        return option;
    }

    @Override
    protected void renderForeground(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        TooltipRenderer.render(matrices, partialTicks);
    }

    @Override
    public void method_25419() {
        if (this.cancelled) {
            TooltipRenderer.resetState();
            super.method_25419();
            return;
        }
        if (((String)this.idVal.getValue()).isBlank()) {
            this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)new class_2588("config.waila.missing_input"), (class_2561)new class_2588("config.waila.overlay_theme_editor.id_empty")));
        } else {
            class_2960 id = new class_2960((String)this.idVal.getValue());
            if (id.method_12836().equals("minecraft") && !((String)this.idVal.getValue()).startsWith("minecraft:")) {
                id = new class_2960("custom", id.method_12832());
            }
            this.parent.addTheme(new Theme(id, (Integer)this.bgColorVal.getValue(), (Integer)this.gradStartVal.getValue(), (Integer)this.gradEndVal.getValue(), (Integer)this.textColorVal.getValue()));
            TooltipRenderer.resetState();
            super.method_25419();
        }
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public float getScale() {
            return 2.0f;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return IWailaConfig.Overlay.Position.Align.Y.TOP;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 1;
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public int getBg() {
            return -16777216 + (Integer)ThemeEditorScreen.this.bgColorVal.getValue();
        }

        @Override
        public int getGradStart() {
            return -16777216 + (Integer)ThemeEditorScreen.this.gradStartVal.getValue();
        }

        @Override
        public int getGradEnd() {
            return -16777216 + (Integer)ThemeEditorScreen.this.gradEndVal.getValue();
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }

        @Override
        public int getFontColor() {
            return (Integer)ThemeEditorScreen.this.textColorVal.getValue();
        }
    }
}

