/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public final class CoordinateUtils {
    static final int SECTION_X_BITS = 22;
    static final long SECTION_X_MASK = 0x3FFFFFL;
    static final int SECTION_Y_BITS = 20;
    static final long SECTION_Y_MASK = 1048575L;
    static final int SECTION_Z_BITS = 22;
    static final long SECTION_Z_MASK = 0x3FFFFFL;
    static final int SECTION_Y_SHIFT = 0;
    static final int SECTION_Z_SHIFT = 20;
    static final int SECTION_X_SHIFT = 42;
    static final int SECTION_TO_BLOCK_SHIFT = 4;

    public static int getNeighbourMappedIndex(int dx, int dz, int radius) {
        return dx + radius + (2 * radius + 1) * (dz + radius);
    }

    public static long getChunkKey(BlockPos pos) {
        return (long)(pos.m_123343_() >> 4) << 32 | (long)(pos.m_123341_() >> 4) & 0xFFFFFFFFL;
    }

    public static long getChunkKey(Entity entity) {
        return (long)(Mth.m_14107_((double)entity.m_20189_()) >> 4) << 32 | (long)(Mth.m_14107_((double)entity.m_20185_()) >> 4) & 0xFFFFFFFFL;
    }

    public static long getChunkKey(ChunkPos pos) {
        return (long)pos.f_45579_ << 32 | (long)pos.f_45578_ & 0xFFFFFFFFL;
    }

    public static long getChunkKey(SectionPos pos) {
        return (long)pos.m_123343_() << 32 | (long)pos.m_123341_() & 0xFFFFFFFFL;
    }

    public static long getChunkKey(int x, int z) {
        return (long)z << 32 | (long)x & 0xFFFFFFFFL;
    }

    public static int getChunkX(long chunkKey) {
        return (int)chunkKey;
    }

    public static int getChunkZ(long chunkKey) {
        return (int)(chunkKey >>> 32);
    }

    public static int getChunkCoordinate(double blockCoordinate) {
        return Mth.m_14107_((double)blockCoordinate) >> 4;
    }

    public static long getChunkSectionKey(int x, int y, int z) {
        return ((long)x & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)z & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(SectionPos pos) {
        return ((long)pos.m_123341_() & 0x3FFFFFL) << 42 | ((long)pos.m_123342_() & 0xFFFFFL) << 0 | ((long)pos.m_123343_() & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(ChunkPos pos, int y) {
        return ((long)pos.f_45578_ & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)pos.f_45579_ & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(BlockPos pos) {
        return (long)pos.m_123341_() << 38 & 0xFFFFFC0000000000L | (long)(pos.m_123342_() >> 4) & 0xFFFFFL | (long)pos.m_123343_() << 16 & 0x3FFFFF00000L;
    }

    public static long getChunkSectionKey(Entity entity) {
        return Mth.m_14134_((double)entity.m_20185_()) << 38 & 0xFFFFFC0000000000L | Mth.m_14134_((double)entity.m_20186_()) >> 4 & 0xFFFFFL | Mth.m_14134_((double)entity.m_20189_()) << 16 & 0x3FFFFF00000L;
    }

    public static int getChunkSectionX(long key) {
        return (int)(key << 0 >> 42);
    }

    public static int getChunkSectionY(long key) {
        return (int)(key << 44 >> 44);
    }

    public static int getChunkSectionZ(long key) {
        return (int)(key << 22 >> 42);
    }

    public static int getBlockCoordinate(double blockCoordinate) {
        return Mth.m_14107_((double)blockCoordinate);
    }

    public static long getBlockKey(int x, int y, int z) {
        return (long)x & 0x7FFFFFFL | ((long)z & 0x7FFFFFFL) << 27 | (long)y << 54;
    }

    public static long getBlockKey(BlockPos pos) {
        return (long)pos.m_123341_() & 0x7FFFFFFL | ((long)pos.m_123343_() & 0x7FFFFFFL) << 27 | (long)pos.m_123342_() << 54;
    }

    public static long getBlockKey(Entity entity) {
        return (long)entity.m_20185_() & 0x7FFFFFFL | ((long)entity.m_20189_() & 0x7FFFFFFL) << 27 | (long)entity.m_20186_() << 54;
    }

    private CoordinateUtils() {
        throw new RuntimeException();
    }
}

