/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.common.config.file.ConfigValue;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ConfigCategory {
    private final String name;
    private final @Unmodifiable Map<String, ConfigValue<?>> valueMap;

    public ConfigCategory(String name, List<ConfigValue<?>> values) {
        this.name = name;
        LinkedHashMap map = new LinkedHashMap();
        for (ConfigValue<?> value : values) {
            map.put(value.getName(), value);
        }
        this.valueMap = Collections.unmodifiableMap(map);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public ConfigValue<?> getConfigValue(String configValueName) {
        return this.valueMap.get(configValueName);
    }

    public Collection<ConfigValue<?>> getConfigValues() {
        return this.valueMap.values();
    }

    public Set<String> getValueNames() {
        return this.valueMap.keySet();
    }
}

