/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.gui.HoverChecker;
import mezz.jei.common.gui.elements.HighResolutionDrawable;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.Nullable;

public class ShapelessIcon {
    private final HighResolutionDrawable icon;
    private final HoverChecker hoverChecker;
    private int posX;
    private int posY;

    public ShapelessIcon(Textures textures) {
        this.icon = textures.getShapelessIcon();
        this.hoverChecker = new HoverChecker();
        this.setPosition(0, 0);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        ImmutableRect2i area = new ImmutableRect2i(posX, posY, this.icon.getWidth(), this.icon.getHeight());
        this.hoverChecker.updateBounds(area);
    }

    public void draw(PoseStack poseStack) {
        this.icon.draw(poseStack, this.posX, this.posY);
    }

    @Nullable
    public List<Component> getTooltipStrings(int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            return List.of(new TranslatableComponent("jei.tooltip.shapeless.recipe"));
        }
        return null;
    }
}

