/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.compostable;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.common.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class CompostableRecipeCategory
implements IRecipeCategory<IJeiCompostingRecipe> {
    public static final int width = 120;
    public static final int height = 18;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    private final Component localizedName;

    public CompostableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(120, 18);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50715_));
        this.localizedName = new TranslatableComponent("gui.jei.category.compostable");
    }

    @Override
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Override
    public Class<? extends IJeiCompostingRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @Override
    public RecipeType<IJeiCompostingRecipe> getRecipeType() {
        return RecipeTypes.COMPOSTING;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiCompostingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(recipe.getInputs());
    }

    @Override
    public void draw(IJeiCompostingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        this.slot.draw(poseStack);
        float chance = recipe.getChance();
        int chancePercent = (int)Math.floor(chance * 100.0f);
        String text = Translator.translateToLocalFormatted("gui.jei.category.compostable.chance", chancePercent);
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        font.m_92883_(poseStack, text, 24.0f, 5.0f, -8355712);
    }
}

