/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.ingredients.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.color.ColorGetter;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;

    public ItemStackHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    @Override
    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.m_41786_();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull(displayName, "itemStack.getDisplayName()");
        return displayName;
    }

    @Override
    public String getUniqueId(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, context);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return StackHelper.getRegistryNameForStack(ingredient);
    }

    @Override
    public String getModId(ItemStack ingredient) {
        ResourceLocation resourceLocation = this.getResourceLocation(ingredient);
        return resourceLocation.m_135827_();
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        String modId = itemStackHelper.getCreatorModId(ingredient);
        if (modId == null) {
            IPlatformRegistry<Item> registry = Services.PLATFORM.getRegistry(Registry.f_122904_);
            ResourceLocation registryName = registry.getRegistryName(ingredient.m_41720_());
            if (registryName == null) {
                String stackInfo = this.getErrorInfo(ingredient);
                throw new IllegalStateException("null registryName for: " + stackInfo);
            }
            modId = registryName.m_135827_();
        }
        return modId;
    }

    @Override
    public Iterable<Integer> getColors(ItemStack ingredient) {
        return ColorGetter.getColors(ingredient, 2);
    }

    @Override
    public String getResourceId(ItemStack ingredient) {
        ResourceLocation resourceLocation = this.getResourceLocation(ingredient);
        return resourceLocation.m_135815_();
    }

    @Override
    public ResourceLocation getResourceLocation(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.m_41720_();
        IPlatformRegistry<Item> itemRegistry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        ResourceLocation name = itemRegistry.getRegistryName(item);
        if (name == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return name;
    }

    @Override
    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.m_41777_();
    }

    @Override
    public ItemStack normalizeIngredient(ItemStack ingredient) {
        ItemStack copy = ingredient.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.m_41619_();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.m_41720_();
        IPlatformRegistry<Item> registry = Services.PLATFORM.getRegistry(Registry.f_122904_);
        return registry.contains(item);
    }

    @Override
    public Collection<ResourceLocation> getTags(ItemStack ingredient) {
        return TagUtil.getTags(ingredient.m_204131_());
    }

    @Override
    public Collection<String> getCreativeTabNames(ItemStack ingredient) {
        ArrayList<String> creativeTabsStrings = new ArrayList<String>();
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        for (CreativeModeTab itemGroup : itemStackHelper.getCreativeTabs(ingredient)) {
            if (itemGroup == null) continue;
            String creativeTabName = itemGroup.m_40786_().getString();
            creativeTabsStrings.add(creativeTabName);
        }
        return creativeTabsStrings;
    }

    @Override
    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }

    @Override
    public Optional<ResourceLocation> getTagEquivalent(Collection<ItemStack> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, ItemStack::m_41720_, () -> ((DefaultedRegistry)Registry.f_122827_).m_203612_());
    }
}

