/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.clipboard.ClipboardEditPacket;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class ClipboardScreen
extends AbstractSimiScreen {
    public ItemStack item;
    public BlockPos targetedBlock;
    List<List<ClipboardEntry>> pages;
    List<ClipboardEntry> currentEntries;
    int editingIndex;
    int frameTick;
    PageButton forward;
    PageButton backward;
    int currentPage;
    long lastClickTime;
    int lastIndex = -1;
    int hoveredEntry;
    boolean hoveredCheck;
    boolean readonly;
    DisplayCache displayCache = DisplayCache.EMPTY;
    TextFieldHelper editContext;
    IconButton closeBtn;
    IconButton clearBtn;
    private int targetSlot;

    public ClipboardScreen(int targetSlot, ItemStack item, @Nullable BlockPos pos) {
        this.targetSlot = targetSlot;
        this.targetedBlock = pos;
        this.reopenWith(item);
    }

    public void reopenWith(ItemStack clipboard) {
        this.item = clipboard;
        this.pages = ClipboardEntry.readAll(this.item);
        if (this.pages.isEmpty()) {
            this.pages.add(new ArrayList());
        }
        if (this.clearBtn == null) {
            this.currentPage = this.item.m_41783_() == null ? 0 : this.item.m_41783_().m_128451_("PreviouslyOpenedPage");
            this.currentPage = Mth.m_14045_((int)this.currentPage, (int)0, (int)(this.pages.size() - 1));
        }
        this.currentEntries = this.pages.get(this.currentPage);
        boolean startEmpty = this.currentEntries.isEmpty();
        if (startEmpty) {
            this.currentEntries.add(new ClipboardEntry(false, Components.empty()));
        }
        this.editingIndex = 0;
        this.editContext = new TextFieldHelper(this::getCurrentEntryText, this::setCurrentEntryText, this::getClipboard, this::setClipboard, this::validateTextForEntry);
        this.editingIndex = startEmpty ? 0 : -1;
        boolean bl = this.readonly = this.item.m_41783_() != null && this.item.m_41783_().m_128471_("Readonly");
        if (this.readonly) {
            this.editingIndex = -1;
        }
        if (this.clearBtn != null) {
            this.m_7856_();
        }
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(256, 256);
        super.m_7856_();
        this.f_96541_.f_91068_.m_90926_(true);
        this.clearDisplayCache();
        int x = this.guiLeft;
        int y = this.guiTop - 8;
        this.m_169413_();
        this.clearBtn = (IconButton)new IconButton(x + 234, y + 153, AllIcons.I_CLEAR_CHECKED).withCallback(() -> {
            this.editingIndex = -1;
            this.currentEntries.removeIf(ce -> ce.checked);
            if (this.currentEntries.isEmpty()) {
                this.currentEntries.add(new ClipboardEntry(false, Components.empty()));
            }
            this.sendIfEditingBlock();
        });
        this.clearBtn.setToolTip((Component)Lang.translateDirect("gui.clipboard.erase_checked", new Object[0]));
        this.closeBtn = (IconButton)new IconButton(x + 234, y + 175, AllIcons.I_PRIORITY_VERY_LOW).withCallback(() -> this.f_96541_.m_91152_(null));
        this.closeBtn.setToolTip((Component)Lang.translateDirect("station.close", new Object[0]));
        this.m_142416_(this.closeBtn);
        this.m_142416_(this.clearBtn);
        this.forward = new PageButton(x + 176, y + 229, true, $ -> this.changePage(true), true);
        this.backward = new PageButton(x + 53, y + 229, false, $ -> this.changePage(false), true);
        this.m_142416_((GuiEventListener)this.forward);
        this.m_142416_((GuiEventListener)this.backward);
        this.forward.f_93624_ = this.currentPage < 50 && (!this.readonly || this.currentPage + 1 < this.pages.size());
        this.backward.f_93624_ = this.currentPage > 0;
    }

    private int getNumPages() {
        return this.pages.size();
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        ++this.frameTick;
        if (this.targetedBlock != null) {
            if (!this.f_96541_.f_91074_.m_142538_().m_123314_((Vec3i)this.targetedBlock, 10.0)) {
                this.m_7861_();
                return;
            }
            if (!AllBlocks.CLIPBOARD.has(this.f_96541_.f_91073_.m_8055_(this.targetedBlock))) {
                this.m_7861_();
                return;
            }
        }
        int mx = (int)(this.f_96541_.f_91067_.m_91589_() * (double)this.f_96541_.m_91268_().m_85445_() / (double)this.f_96541_.m_91268_().m_85443_());
        int my = (int)(this.f_96541_.f_91067_.m_91594_() * (double)this.f_96541_.m_91268_().m_85446_() / (double)this.f_96541_.m_91268_().m_85444_());
        this.hoveredCheck = false;
        this.hoveredEntry = -1;
        if ((mx -= this.guiLeft + 35) > 0 && mx < 183 && (my -= this.guiTop + 41) > 0 && my < 190) {
            this.hoveredCheck = mx < 20;
            int totalHeight = 0;
            for (int i = 0; i < this.currentEntries.size(); ++i) {
                ClipboardEntry clipboardEntry = this.currentEntries.get(i);
                String text = clipboardEntry.text.getString();
                if ((totalHeight += Math.max(12, this.f_96547_.m_92923_((FormattedText)Components.literal(text), clipboardEntry.icon.m_41619_() ? 150 : 130).size() * 9 + 3)) <= my) continue;
                this.hoveredEntry = i;
                return;
            }
            this.hoveredEntry = this.currentEntries.size();
        }
    }

    private String getCurrentEntryText() {
        return this.currentEntries.get((int)this.editingIndex).text.getString();
    }

    private void setCurrentEntryText(String text) {
        this.currentEntries.get((int)this.editingIndex).text = Components.literal(text);
        this.sendIfEditingBlock();
    }

    private void setClipboard(String p_98148_) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)p_98148_);
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    private boolean validateTextForEntry(String newText) {
        int totalHeight = 0;
        for (int i = 0; i < this.currentEntries.size(); ++i) {
            ClipboardEntry clipboardEntry = this.currentEntries.get(i);
            String text = i == this.editingIndex ? newText : clipboardEntry.text.getString();
            totalHeight += Math.max(12, this.f_96547_.m_92923_((FormattedText)Components.literal(text), 150).size() * 9 + 3);
        }
        return totalHeight < 185;
    }

    private int yOffsetOfEditingEntry() {
        int totalHeight = 0;
        for (int i = 0; i < this.currentEntries.size() && i != this.editingIndex; ++i) {
            ClipboardEntry clipboardEntry = this.currentEntries.get(i);
            totalHeight += Math.max(12, this.f_96547_.m_92923_((FormattedText)clipboardEntry.text, 150).size() * 9 + 3);
        }
        return totalHeight;
    }

    private void changePage(boolean next) {
        int previously = this.currentPage;
        this.currentPage = Mth.m_14045_((int)(this.currentPage + (next ? 1 : -1)), (int)0, (int)50);
        if (this.currentPage == previously) {
            return;
        }
        this.editingIndex = -1;
        if (this.pages.size() <= this.currentPage) {
            if (this.readonly) {
                this.currentPage = previously;
                return;
            }
            this.pages.add(new ArrayList());
        }
        this.currentEntries = this.pages.get(this.currentPage);
        if (this.currentEntries.isEmpty()) {
            this.currentEntries.add(new ClipboardEntry(false, Components.empty()));
            if (!this.readonly) {
                this.editingIndex = 0;
                this.editContext.m_95193_();
                this.clearDisplayCacheAfterChange();
            }
        }
        this.forward.f_93624_ = this.currentPage < 50 && (!this.readonly || this.currentPage + 1 < this.pages.size());
        boolean bl = this.backward.f_93624_ = this.currentPage > 0;
        if (next) {
            return;
        }
        if (this.pages.get(this.currentPage + 1).stream().allMatch(ce -> ce.text.getString().isBlank())) {
            this.pages.remove(this.currentPage + 1);
        }
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop - 8;
        AllGuiTextures.CLIPBOARD.render(ms, x, y);
        this.f_96547_.m_92889_(ms, (Component)new TranslatableComponent("book.pageIndicator", new Object[]{this.currentPage + 1, this.getNumPages()}), (float)(x + 150), (float)(y + 9), 0x43FFFFFF);
        for (int i = 0; i < this.currentEntries.size(); ++i) {
            List split;
            ClipboardEntry clipboardEntry = this.currentEntries.get(i);
            boolean checked = clipboardEntry.checked;
            int iconOffset = clipboardEntry.icon.m_41619_() ? 0 : 16;
            this.f_96547_.m_92883_(ms, "\u25a1", (float)(x + 45), (float)(y + 51), checked ? 1720549227 : -7504021);
            if (checked) {
                this.f_96547_.m_92883_(ms, "\u2714", (float)(x + 45), (float)(y + 50), 3256925);
            }
            if ((split = this.f_96547_.m_92923_((FormattedText)clipboardEntry.text, 150 - iconOffset)).isEmpty()) {
                y += 12;
                continue;
            }
            if (!clipboardEntry.icon.m_41619_()) {
                this.f_96542_.m_115123_(clipboardEntry.icon, x + 54, y + 50);
            }
            for (FormattedCharSequence sequence : split) {
                if (i != this.editingIndex) {
                    this.f_96547_.m_92877_(ms, sequence, (float)(x + 58 + iconOffset), (float)(y + 50), checked ? 3256925 : 3217920);
                }
                y += 9;
            }
            y += 3;
        }
        if (this.editingIndex == -1) {
            return;
        }
        boolean checked = this.currentEntries.get((int)this.editingIndex).checked;
        this.m_7522_(null);
        DisplayCache cache = this.getDisplayCache();
        for (LineInfo line : cache.lines) {
            this.f_96547_.m_92889_(ms, line.asComponent, (float)line.x, (float)line.y, checked ? 3256925 : 3217920);
        }
        this.renderHighlight(cache.selection);
        this.renderCursor(ms, cache.cursor, cache.cursorAtEnd);
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
        this.pages.forEach(list -> list.removeIf(ce -> ce.text.getString().isBlank()));
        this.pages.removeIf(List::isEmpty);
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pages.get(i) != this.currentEntries) continue;
            this.item.m_41784_().m_128405_("PreviouslyOpenedPage", i);
        }
        this.send();
        super.m_7861_();
    }

    private void sendIfEditingBlock() {
        ClientPacketListener handler = this.f_96541_.f_91074_.f_108617_;
        if (handler.m_105142_().size() > 1 && this.targetedBlock != null) {
            this.send();
        }
    }

    private void send() {
        ClipboardEntry.saveAll(this.pages, this.item);
        ClipboardOverrides.switchTo(ClipboardOverrides.ClipboardType.WRITTEN, this.item);
        if (this.pages.isEmpty()) {
            this.item.m_41751_(new CompoundTag());
        }
        AllPackets.getChannel().sendToServer((Object)new ClipboardEditPacket(this.targetSlot, this.item.m_41784_(), this.targetedBlock));
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        this.changePage(pDelta < 0.0);
        return true;
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 266) {
            this.backward.m_5691_();
            return true;
        }
        if (pKeyCode == 267) {
            this.forward.m_5691_();
            return true;
        }
        if (this.editingIndex != -1 && pKeyCode != 256) {
            this.keyPressedWhileEditing(pKeyCode, pScanCode, pModifiers);
            this.clearDisplayCache();
            return true;
        }
        if (super.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return true;
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (super.m_5534_(pCodePoint, pModifiers)) {
            return true;
        }
        if (!SharedConstants.m_136188_((char)pCodePoint)) {
            return false;
        }
        if (this.editingIndex == -1) {
            return false;
        }
        this.editContext.m_95158_(Character.toString(pCodePoint));
        this.clearDisplayCache();
        return true;
    }

    private boolean keyPressedWhileEditing(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.m_96634_((int)pKeyCode)) {
            this.editContext.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)pKeyCode)) {
            this.editContext.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)pKeyCode)) {
            this.editContext.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)pKeyCode)) {
            this.editContext.m_95142_();
            return true;
        }
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (ClipboardScreen.m_96638_()) {
                    this.editContext.m_95158_("\n");
                    return true;
                }
                if (!ClipboardScreen.m_96637_()) {
                    if (this.currentEntries.size() <= this.editingIndex + 1 || !this.currentEntries.get((int)(this.editingIndex + 1)).text.getString().isEmpty()) {
                        this.currentEntries.add(this.editingIndex + 1, new ClipboardEntry(false, Components.empty()));
                    }
                    ++this.editingIndex;
                    this.editContext.m_95193_();
                    if (this.validateTextForEntry(" ")) {
                        return true;
                    }
                    this.currentEntries.remove(this.editingIndex);
                    --this.editingIndex;
                    this.editContext.m_95193_();
                    return true;
                }
                this.editingIndex = -1;
                return true;
            }
            case 259: {
                if (this.currentEntries.get((int)this.editingIndex).text.getString().isEmpty() && this.currentEntries.size() > 1) {
                    this.currentEntries.remove(this.editingIndex);
                    this.editingIndex = Math.max(0, this.editingIndex - 1);
                    this.editContext.m_95193_();
                    return true;
                }
                if (ClipboardScreen.m_96637_()) {
                    int prevPos = this.editContext.m_95194_();
                    this.editContext.m_169095_(-1);
                    if (prevPos != this.editContext.m_95194_()) {
                        this.editContext.m_95189_(prevPos - this.editContext.m_95194_());
                    }
                    return true;
                }
                this.editContext.m_95189_(-1);
                return true;
            }
            case 261: {
                if (ClipboardScreen.m_96637_()) {
                    int prevPos = this.editContext.m_95194_();
                    this.editContext.m_169095_(1);
                    if (prevPos != this.editContext.m_95194_()) {
                        this.editContext.m_95189_(prevPos - this.editContext.m_95194_());
                    }
                    return true;
                }
                this.editContext.m_95189_(1);
                return true;
            }
            case 262: {
                if (ClipboardScreen.m_96637_()) {
                    this.editContext.m_95166_(1, Screen.m_96638_());
                    return true;
                }
                this.editContext.m_95150_(1, Screen.m_96638_());
                return true;
            }
            case 263: {
                if (ClipboardScreen.m_96637_()) {
                    this.editContext.m_95166_(-1, Screen.m_96638_());
                    return true;
                }
                this.editContext.m_95150_(-1, Screen.m_96638_());
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.keyEnd();
                return true;
            }
        }
        return false;
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int pYChange) {
        int i = this.editContext.m_95194_();
        int j = this.getDisplayCache().changeLine(i, pYChange);
        this.editContext.m_95179_(j, Screen.m_96638_());
    }

    private void keyHome() {
        int i = this.editContext.m_95194_();
        int j = this.getDisplayCache().findLineStart(i);
        this.editContext.m_95179_(j, Screen.m_96638_());
    }

    private void keyEnd() {
        DisplayCache cache = this.getDisplayCache();
        int i = this.editContext.m_95194_();
        int j = cache.findLineEnd(i);
        this.editContext.m_95179_(j, Screen.m_96638_());
    }

    private void renderCursor(PoseStack pPoseStack, Pos2i pCursorPos, boolean pIsEndOfText) {
        if (this.frameTick / 6 % 2 != 0) {
            return;
        }
        pCursorPos = this.convertLocalToScreen(pCursorPos);
        if (!pIsEndOfText) {
            GuiComponent.m_93172_((PoseStack)pPoseStack, (int)pCursorPos.x, (int)(pCursorPos.y - 1), (int)(pCursorPos.x + 1), (int)(pCursorPos.y + 9), (int)-16777216);
        } else {
            this.f_96547_.m_92883_(pPoseStack, "_", (float)pCursorPos.x, (float)pCursorPos.y, 0);
        }
    }

    private void renderHighlight(Rect2i[] pSelected) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (Rect2i rect2i : pSelected) {
            int i = rect2i.m_110085_();
            int j = rect2i.m_110086_();
            int k = i + rect2i.m_110090_();
            int l = j + rect2i.m_110091_();
            bufferbuilder.m_5483_((double)i, (double)l, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k, (double)l, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)k, (double)j, 0.0).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)j, 0.0).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.m_69462_();
        RenderSystem.m_69493_();
    }

    private Pos2i convertScreenToLocal(Pos2i pScreenPos) {
        return new Pos2i(pScreenPos.x - (this.f_96543_ - 192) / 2 - 36 + 10, pScreenPos.y - 32 - 24 - this.yOffsetOfEditingEntry() - this.guiTop + 14);
    }

    private Pos2i convertLocalToScreen(Pos2i pLocalScreenPos) {
        return new Pos2i(pLocalScreenPos.x + (this.f_96543_ - 192) / 2 + 36 - 10, pLocalScreenPos.y + 32 + 24 + this.yOffsetOfEditingEntry() + this.guiTop - 14);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pButton != 0) {
            return true;
        }
        if (this.hoveredEntry != -1) {
            if (this.hoveredCheck) {
                this.editingIndex = -1;
                if (this.hoveredEntry < this.currentEntries.size()) {
                    this.currentEntries.get((int)this.hoveredEntry).checked ^= true;
                }
                this.sendIfEditingBlock();
                return true;
            }
            if (this.hoveredEntry != this.editingIndex && !this.readonly) {
                this.editingIndex = this.hoveredEntry;
                if (this.hoveredEntry >= this.currentEntries.size()) {
                    this.currentEntries.add(new ClipboardEntry(false, Components.empty()));
                    if (!this.validateTextForEntry(" ")) {
                        this.currentEntries.remove(this.hoveredEntry);
                        this.editingIndex = -1;
                        return true;
                    }
                }
                this.clearDisplayCacheAfterChange();
            }
        }
        if (this.editingIndex == -1) {
            return false;
        }
        long i = Util.m_137550_();
        DisplayCache cache = this.getDisplayCache();
        int j = cache.getIndexAtPosition(this.f_96547_, this.convertScreenToLocal(new Pos2i((int)pMouseX, (int)pMouseY)));
        if (j >= 0) {
            if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                if (!this.editContext.m_95198_()) {
                    this.selectWord(j);
                } else {
                    this.editContext.m_95188_();
                }
            } else {
                this.editContext.m_95179_(j, Screen.m_96638_());
            }
            this.clearDisplayCache();
        }
        this.lastIndex = j;
        this.lastClickTime = i;
        return true;
    }

    private void selectWord(int pIndex) {
        String s = this.getCurrentEntryText();
        this.editContext.m_95147_(StringSplitter.m_92355_((String)s, (int)-1, (int)pIndex, (boolean)false), StringSplitter.m_92355_((String)s, (int)1, (int)pIndex, (boolean)false));
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY)) {
            return true;
        }
        if (pButton != 0) {
            return true;
        }
        if (this.editingIndex == -1) {
            return false;
        }
        DisplayCache cache = this.getDisplayCache();
        int i = cache.getIndexAtPosition(this.f_96547_, this.convertScreenToLocal(new Pos2i((int)pMouseX, (int)pMouseY)));
        this.editContext.m_95179_(i, true);
        this.clearDisplayCache();
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private void clearDisplayCacheAfterChange() {
        this.editContext.m_95193_();
        this.clearDisplayCache();
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos;
        boolean flag;
        String s = this.getCurrentEntryText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.editContext.m_95194_();
        int j = this.editContext.m_95197_();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.f_96547_.m_92865_();
        stringsplitter.m_92364_(s, 150, Style.f_131099_, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$8(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] aint = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos = new Pos2i(0, list.size() * 9);
        } else {
            int k = ClipboardScreen.findLineFromPos(aint, i);
            int l = this.f_96547_.m_92895_(s.substring(aint[k], i));
            pos = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = ClipboardScreen.findLineFromPos(aint, l2);
            if (j1 == (k1 = ClipboardScreen.findLineFromPos(aint, i1))) {
                int l1 = j1 * 9;
                int i2 = aint[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > aint.length ? s.length() : aint[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, aint[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(aint[j3], aint[j3 + 1]);
                    int k2 = (int)stringsplitter.m_92353_(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, aint[k1], i1, k1 * 9, aint[k1]));
            }
        }
        return new DisplayCache(s, pos, flag, aint, list.toArray(new LineInfo[0]), list1.toArray(new Rect2i[0]));
    }

    static int findLineFromPos(int[] pLineStarts, int pFind) {
        int i = Arrays.binarySearch(pLineStarts, pFind);
        return i < 0 ? -(i + 2) : i;
    }

    private Rect2i createPartialLineSelection(String pInput, StringSplitter pSplitter, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = pInput.substring(p_98125_, p_98122_);
        String s1 = pInput.substring(p_98125_, p_98123_);
        Pos2i firstPos = new Pos2i((int)pSplitter.m_92353_(s), p_98124_);
        Pos2i secondPos = new Pos2i((int)pSplitter.m_92353_(s1), p_98124_ + 9);
        return this.createSelection(firstPos, secondPos);
    }

    private Rect2i createSelection(Pos2i pCorner1, Pos2i pCorner2) {
        Pos2i firstPos = this.convertLocalToScreen(pCorner1);
        Pos2i secondPos = this.convertLocalToScreen(pCorner2);
        int i = Math.min(firstPos.x, secondPos.x);
        int j = Math.max(firstPos.x, secondPos.x);
        int k = Math.min(firstPos.y, secondPos.y);
        int l = Math.max(firstPos.y, secondPos.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$8(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, Style p_98132_, int p_98133_, int p_98134_) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(p_98133_, p_98134_);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos1 = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(p_98133_);
        list.add(new LineInfo(p_98132_, s3, pos1.x, pos1.y));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final Rect2i[] selection;

        public DisplayCache(String pFullText, Pos2i pCursor, boolean pCursorAtEnd, int[] pLineStarts, LineInfo[] pLines, Rect2i[] pSelection) {
            this.fullText = pFullText;
            this.cursor = pCursor;
            this.cursorAtEnd = pCursorAtEnd;
            this.lineStarts = pLineStarts;
            this.lines = pLines;
            this.selection = pSelection;
        }

        public int getIndexAtPosition(Font pFont, Pos2i pCursorPosition) {
            int i = pCursorPosition.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo line = this.lines[i];
            return this.lineStarts[i] + pFont.m_92865_().m_92360_(line.contents, pCursorPosition.x, line.style);
        }

        public int changeLine(int pXChange, int pYChange) {
            int k;
            int i = ClipboardScreen.findLineFromPos(this.lineStarts, pXChange);
            int j = i + pYChange;
            if (0 <= j && j < this.lineStarts.length) {
                int l = pXChange - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = pXChange;
            }
            return k;
        }

        public int findLineStart(int pLine) {
            int i = ClipboardScreen.findLineFromPos(this.lineStarts, pLine);
            return this.lineStarts[i];
        }

        public int findLineEnd(int pLine) {
            int i = ClipboardScreen.findLineFromPos(this.lineStarts, pLine);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LineInfo {
        final Style style;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;

        public LineInfo(Style pStyle, String pContents, int pX, int pY) {
            this.style = pStyle;
            this.contents = pContents;
            this.x = pX;
            this.y = pY;
            this.asComponent = new TextComponent(pContents).m_6270_(pStyle);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int pX, int pY) {
            this.x = pX;
            this.y = pY;
        }
    }
}

