/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper.terrainzapper;

import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.content.equipment.zapper.terrainzapper.Brush;
import com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainBrushes;
import com.simibubi.create.content.equipment.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.content.equipment.zapper.terrainzapper.WorldshaperItemRenderer;
import com.simibubi.create.content.equipment.zapper.terrainzapper.WorldshaperScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;

public class WorldshaperItem
extends ZapperItem {
    public WorldshaperItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void openHandgunGUI(ItemStack item, InteractionHand hand) {
        ScreenOpener.open(new WorldshaperScreen(item, hand));
    }

    @Override
    protected int getZappingRange(ItemStack stack) {
        return 128;
    }

    @Override
    protected int getCooldownDelay(ItemStack item) {
        return 2;
    }

    @Override
    public Component validateUsage(ItemStack item) {
        if (!item.m_41784_().m_128441_("BrushParams")) {
            return Lang.translateDirect("terrainzapper.shiftRightClickToSet", new Object[0]);
        }
        return super.validateUsage(item);
    }

    @Override
    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        TerrainTools tool = NBTHelper.readEnum(tag, "Tool", TerrainTools.class);
        return !tool.requiresSelectedBlock();
    }

    @Override
    protected boolean activate(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data) {
        BlockPos targetPos = raytrace.m_82425_();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        CompoundTag tag = stack.m_41784_();
        Brush brush = NBTHelper.readEnum(tag, "Brush", TerrainBrushes.class).get();
        BlockPos params = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BrushParams"));
        PlacementOptions option = NBTHelper.readEnum(tag, "Placement", PlacementOptions.class);
        TerrainTools tool = NBTHelper.readEnum(tag, "Tool", TerrainTools.class);
        brush.set(params.m_123341_(), params.m_123342_(), params.m_123343_());
        targetPos = targetPos.m_141952_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), option));
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.m_82434_(), affectedPositions, tool);
        PlacementPatterns.applyPattern(affectedPositions, stack);
        brush.redirectTool(tool).run(world, affectedPositions, raytrace.m_82434_(), stateToUse, data, player);
        return true;
    }

    public static void configureSettings(ItemStack stack, PlacementPatterns pattern, TerrainBrushes brush, int brushParamX, int brushParamY, int brushParamZ, TerrainTools tool, PlacementOptions placement) {
        ZapperItem.configureSettings(stack, pattern);
        CompoundTag nbt = stack.m_41784_();
        NBTHelper.writeEnum(nbt, "Brush", brush);
        nbt.m_128365_("BrushParams", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(brushParamX, brushParamY, brushParamZ)));
        NBTHelper.writeEnum(nbt, "Tool", tool);
        NBTHelper.writeEnum(nbt, "Placement", placement);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(SimpleCustomRenderer.create(this, new WorldshaperItemRenderer()));
    }
}

