/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.google.common.base.Strings;
import com.simibubi.create.AllEntityDataSerializers;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionBlockChangedPacket;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.content.trains.TrainHUDUpdatePacket;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionInstance;
import com.simibubi.create.content.trains.entity.CarriageParticles;
import com.simibubi.create.content.trains.entity.CarriageSounds;
import com.simibubi.create.content.trains.entity.CarriageSyncData;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainPromptPacket;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class CarriageContraptionEntity
extends OrientedContraptionEntity {
    private static final EntityDataAccessor<CarriageSyncData> CARRIAGE_DATA = SynchedEntityData.m_135353_(CarriageContraptionEntity.class, (EntityDataSerializer)AllEntityDataSerializers.CARRIAGE_DATA);
    private static final EntityDataAccessor<Optional<UUID>> TRACK_GRAPH = SynchedEntityData.m_135353_(CarriageContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> SCHEDULED = SynchedEntityData.m_135353_(CarriageContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public UUID trainId;
    public int carriageIndex;
    private Carriage carriage;
    public boolean validForRender = false;
    public boolean movingBackwards;
    public boolean leftTickingChunks;
    public boolean firstPositionUpdate = true;
    private boolean arrivalSoundPlaying;
    private boolean arrivalSoundReversed;
    private int arrivalSoundTicks;
    private Vec3 serverPrevPos;
    @OnlyIn(value=Dist.CLIENT)
    public CarriageSounds sounds;
    @OnlyIn(value=Dist.CLIENT)
    public CarriageParticles particles;
    Vec3 derailParticleOffset = VecHelper.offsetRandomly(Vec3.f_82478_, Create.RANDOM, 1.5f).m_82542_(1.0, 0.25, 1.0);
    private Set<BlockPos> particleSlice = new HashSet<BlockPos>();
    private float particleAvgY = 0.0f;
    double navDistanceTotal = 0.0;
    int hudPacketCooldown = 0;
    boolean stationMessage = false;
    @OnlyIn(value=Dist.CLIENT)
    private WeakReference<CarriageContraptionInstance> instanceHolder;

    public CarriageContraptionEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.arrivalSoundTicks = Integer.MIN_VALUE;
    }

    public boolean m_6109_() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARRIAGE_DATA, (Object)new CarriageSyncData());
        this.f_19804_.m_135372_(TRACK_GRAPH, Optional.empty());
        this.f_19804_.m_135372_(SCHEDULED, (Object)false);
    }

    public void syncCarriage() {
        CarriageSyncData carriageData = this.getCarriageData();
        if (carriageData == null) {
            return;
        }
        if (this.carriage == null) {
            return;
        }
        carriageData.update(this, this.carriage);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (!this.f_19853_.f_46443_) {
            return;
        }
        this.bindCarriage();
        if (TRACK_GRAPH.equals(key)) {
            this.updateTrackGraph();
        }
        if (CARRIAGE_DATA.equals(key)) {
            CarriageSyncData carriageData = this.getCarriageData();
            if (carriageData == null) {
                return;
            }
            if (this.carriage == null) {
                return;
            }
            carriageData.apply(this, this.carriage);
        }
    }

    public CarriageSyncData getCarriageData() {
        return (CarriageSyncData)this.f_19804_.m_135370_(CARRIAGE_DATA);
    }

    public boolean hasSchedule() {
        return (Boolean)this.f_19804_.m_135370_(SCHEDULED);
    }

    public void setServerSidePrevPosition() {
        this.serverPrevPos = this.m_20182_();
    }

    @Override
    public Vec3 getPrevPositionVec() {
        if (!this.f_19853_.m_5776_() && this.serverPrevPos != null) {
            return this.serverPrevPos;
        }
        return super.getPrevPositionVec();
    }

    public boolean isLocalCoordWithin(BlockPos localPos, int min, int max) {
        Contraption contraption = this.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        Direction facing = cc.getAssemblyDirection();
        Direction.Axis axis = facing.m_122427_().m_122434_();
        int coord = axis.m_7863_(localPos.m_123343_(), localPos.m_123342_(), localPos.m_123341_()) * -facing.m_122421_().m_122540_();
        return coord >= min && coord <= max;
    }

    public static CarriageContraptionEntity create(Level world, CarriageContraption contraption) {
        CarriageContraptionEntity entity = new CarriageContraptionEntity((EntityType)AllEntityTypes.CARRIAGE_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(contraption.getAssemblyDirection().m_122427_());
        entity.startAtInitialYaw();
        return entity;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            for (Entity entity : this.m_20197_()) {
                BlockPos seatOf;
                if (entity instanceof Player || (seatOf = cc.getSeatOf(entity.m_142081_())) == null || cc.conductorSeats.get(seatOf) == null) continue;
                this.alignPassenger(entity);
            }
        }
    }

    @Override
    public void setBlock(BlockPos localPos, StructureTemplate.StructureBlockInfo newInfo) {
        if (this.carriage == null) {
            return;
        }
        this.carriage.forEachPresentEntity(cce -> {
            cce.contraption.getBlocks().put(localPos, newInfo);
            AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> cce), (Object)new ContraptionBlockChangedPacket(cce.m_142049_(), localPos, newInfo.f_74676_));
        });
    }

    @Override
    protected void tickContraption() {
        boolean isStalled;
        Contraption contraption;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if (!((contraption = this.contraption) instanceof CarriageContraption)) {
            return;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        if (this.carriage == null) {
            if (this.f_19853_.f_46443_) {
                this.bindCarriage();
            } else {
                this.m_146870_();
            }
            return;
        }
        if (!Create.RAILWAYS.sided((LevelAccessor)this.f_19853_).trains.containsKey(this.carriage.train.id)) {
            this.m_146870_();
            return;
        }
        this.tickActors();
        this.carriage.stalled = isStalled = this.isStalled();
        CarriageSyncData carriageData = this.getCarriageData();
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(SCHEDULED, (Object)(this.carriage.train.runtime.getSchedule() != null ? 1 : 0));
            boolean shouldCarriageSyncThisTick = this.carriage.train.shouldCarriageSyncThisTick(this.f_19853_.m_46467_(), this.m_6095_().m_20682_());
            if (shouldCarriageSyncThisTick && carriageData.isDirty()) {
                this.f_19804_.m_135381_(CARRIAGE_DATA, null);
                this.f_19804_.m_135381_(CARRIAGE_DATA, (Object)carriageData);
                carriageData.setDirty(false);
            }
            Navigation navigation = this.carriage.train.navigation;
            if (navigation.announceArrival && Math.abs(navigation.distanceToDestination) < 60.0 && this.carriageIndex == (this.carriage.train.speed < 0.0 ? this.carriage.train.carriages.size() - 1 : 0)) {
                navigation.announceArrival = false;
                this.arrivalSoundPlaying = true;
                this.arrivalSoundReversed = this.carriage.train.speed < 0.0;
                this.arrivalSoundTicks = Integer.MIN_VALUE;
            }
            if (this.arrivalSoundPlaying) {
                this.tickArrivalSound(cc);
            }
            this.f_19804_.m_135381_(TRACK_GRAPH, Optional.ofNullable(this.carriage.train.graph).map(g -> g.id));
            return;
        }
        Carriage.DimensionalCarriageEntity dce = this.carriage.getDimensional(this.f_19853_);
        if (this.f_19797_ % 10 == 0) {
            this.updateTrackGraph();
        }
        if (!dce.pointsInitialised) {
            return;
        }
        carriageData.approach(this, this.carriage, 1.0f / (float)this.m_6095_().m_20682_());
        if (!this.carriage.train.derailed) {
            this.carriage.updateContraptionAnchors();
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        dce.alignEntity(this);
        if (this.sounds == null) {
            this.sounds = new CarriageSounds(this);
        }
        this.sounds.tick(dce);
        if (this.particles == null) {
            this.particles = new CarriageParticles(this);
        }
        this.particles.tick(dce);
        double distanceTo = 0.0;
        if (!this.firstPositionUpdate) {
            Vec3 diff = this.m_20182_().m_82492_(this.f_19854_, this.f_19855_, this.f_19856_);
            Vec3 relativeDiff = VecHelper.rotate(diff, this.yaw, Direction.Axis.Y);
            double signum = Math.signum(-relativeDiff.f_82479_);
            distanceTo = diff.m_82553_() * signum;
            this.movingBackwards = signum < 0.0;
        }
        ((CarriageBogey)this.carriage.bogeys.getFirst()).updateAngles(this, distanceTo);
        if (this.carriage.isOnTwoBogeys()) {
            ((CarriageBogey)this.carriage.bogeys.getSecond()).updateAngles(this, distanceTo);
        }
        if (this.carriage.train.derailed) {
            this.spawnDerailParticles(this.carriage);
        }
        if (dce.pivot != null) {
            this.spawnPortalParticles(dce);
        }
        this.firstPositionUpdate = false;
        this.validForRender = true;
    }

    private void bindCarriage() {
        if (this.carriage != null) {
            return;
        }
        Train train = Create.RAILWAYS.sided((LevelAccessor)this.f_19853_).trains.get(this.trainId);
        if (train == null || train.carriages.size() <= this.carriageIndex) {
            return;
        }
        this.carriage = train.carriages.get(this.carriageIndex);
        if (this.carriage != null) {
            Carriage.DimensionalCarriageEntity dimensional = this.carriage.getDimensional(this.f_19853_);
            dimensional.entity = new WeakReference<CarriageContraptionEntity>(this);
            dimensional.pivot = null;
            this.carriage.updateContraptionAnchors();
            dimensional.updateRenderedCutoff();
        }
        this.updateTrackGraph();
    }

    private void tickArrivalSound(CarriageContraption cc) {
        List<Carriage> carriages = this.carriage.train.carriages;
        if (this.arrivalSoundTicks == Integer.MIN_VALUE) {
            int carriageCount = carriages.size();
            Integer tick = null;
            for (int index = 0; index < carriageCount; ++index) {
                Contraption contraption;
                int i = this.arrivalSoundReversed ? carriageCount - 1 - index : index;
                Carriage carriage = carriages.get(i);
                CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)carriage.getDimensional((Level)this.f_19853_).entity.get());
                if (entity == null || !((contraption = entity.contraption) instanceof CarriageContraption)) break;
                CarriageContraption otherCC = (CarriageContraption)contraption;
                Integer n = tick = this.arrivalSoundReversed ? otherCC.soundQueue.lastTick() : otherCC.soundQueue.firstTick();
                if (tick != null) break;
            }
            if (tick == null) {
                this.arrivalSoundPlaying = false;
                return;
            }
            this.arrivalSoundTicks = tick;
        }
        if (this.f_19797_ % 2 == 0) {
            return;
        }
        boolean keepTicking = false;
        for (Carriage c : carriages) {
            Contraption contraption;
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)c.getDimensional((Level)this.f_19853_).entity.get());
            if (entity == null || !((contraption = entity.contraption) instanceof CarriageContraption)) continue;
            CarriageContraption otherCC = (CarriageContraption)contraption;
            keepTicking |= otherCC.soundQueue.tick(entity, this.arrivalSoundTicks, this.arrivalSoundReversed);
        }
        if (!keepTicking) {
            this.arrivalSoundPlaying = false;
            return;
        }
        this.arrivalSoundTicks += this.arrivalSoundReversed ? -1 : 1;
    }

    @Override
    public void tickActors() {
        super.tickActors();
    }

    @Override
    protected boolean isActorActive(MovementContext context, MovementBehaviour actor) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        if (!super.isActorActive(context, actor)) {
            return false;
        }
        return cc.notInPortal() || this.f_19853_.m_5776_();
    }

    @Override
    protected void handleStallInformation(double x, double y, double z, float angle) {
    }

    private void spawnDerailParticles(Carriage carriage) {
        if (this.f_19796_.nextFloat() < 0.05f) {
            Vec3 v = this.m_20182_().m_82549_(this.derailParticleOffset);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.04, 0.0);
        }
    }

    protected void m_20348_(Entity pPassenger) {
        super.m_20348_(pPassenger);
        if (!(pPassenger instanceof Player)) {
            return;
        }
        Player player = (Player)pPassenger;
        player.getPersistentData().m_128365_("ContraptionMountLocation", (Tag)VecHelper.writeNBT(player.m_20182_()));
    }

    private void spawnPortalParticles(Carriage.DimensionalCarriageEntity dce) {
        Vec3 pivot = dce.pivot.getLocation().m_82520_(0.0, 1.5, 0.0);
        if (this.particleSlice.isEmpty()) {
            return;
        }
        boolean alongX = Mth.m_14082_((double)pivot.f_82479_, (double)Math.round(pivot.f_82479_));
        int extraFlip = Direction.m_122364_((double)this.yaw).m_122421_().m_122540_();
        Vec3 emitter = pivot.m_82520_(0.0, (double)this.particleAvgY, 0.0);
        double speed = this.m_20182_().m_82554_(this.getPrevPositionVec());
        int size = (int)((double)this.particleSlice.size() * Mth.m_14008_((double)(4.0 - speed * 4.0), (double)0.0, (double)4.0));
        for (BlockPos pos : this.particleSlice) {
            if (size != 0 && this.f_19796_.nextInt(size) != 0) continue;
            if (alongX) {
                pos = new BlockPos(0, pos.m_123342_(), pos.m_123341_());
            }
            Vec3 v = pivot.m_82520_((double)(pos.m_123341_() * extraFlip), (double)pos.m_123342_(), (double)(pos.m_123343_() * extraFlip));
            CubeParticleData data = new CubeParticleData(0.25f, 0.0f, 0.5f, 0.65f + (this.f_19796_.nextFloat() - 0.5f) * 0.25f, 4, false);
            Vec3 m = v.m_82546_(emitter).m_82541_().m_82490_((double)0.325f);
            m = VecHelper.rotate(m, this.f_19796_.nextFloat() * 360.0f, alongX ? Direction.Axis.X : Direction.Axis.Z);
            m = m.m_82549_(VecHelper.offsetRandomly(Vec3.f_82478_, this.f_19796_, 0.25f));
            this.f_19853_.m_7106_((ParticleOptions)data, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public void m_142036_() {
        super.m_142036_();
        this.f_19804_.m_135381_(CARRIAGE_DATA, (Object)new CarriageSyncData());
        if (this.carriage != null) {
            Carriage.DimensionalCarriageEntity dce = this.carriage.getDimensional(this.f_19853_);
            dce.pointsInitialised = false;
            this.carriage.leadingBogey().couplingAnchors = Couple.create(null, null);
            this.carriage.trailingBogey().couplingAnchors = Couple.create(null, null);
        }
        this.firstPositionUpdate = true;
        if (this.sounds != null) {
            this.sounds.stop();
        }
    }

    @Override
    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        super.writeAdditional(compound, spawnPacket);
        compound.m_128362_("TrainId", this.trainId);
        compound.m_128405_("CarriageIndex", this.carriageIndex);
    }

    @Override
    protected void readAdditional(CompoundTag compound, boolean spawnPacket) {
        super.readAdditional(compound, spawnPacket);
        this.trainId = compound.m_128342_("TrainId");
        this.carriageIndex = compound.m_128451_("CarriageIndex");
        if (spawnPacket) {
            this.f_19790_ = this.m_20185_();
            this.f_19791_ = this.m_20186_();
            this.f_19792_ = this.m_20189_();
        }
    }

    @Override
    public Component getContraptionName() {
        if (this.carriage != null) {
            return this.carriage.train.name;
        }
        Component contraptionName = super.getContraptionName();
        return contraptionName;
    }

    public Couple<Boolean> checkConductors() {
        Couple<Boolean> sides = Couple.create(false, false);
        Contraption contraption = this.contraption;
        if (!(contraption instanceof CarriageContraption)) {
            return sides;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        sides.setFirst((Boolean)cc.blazeBurnerConductors.getFirst());
        sides.setSecond((Boolean)cc.blazeBurnerConductors.getSecond());
        for (Entity entity : this.m_20197_()) {
            Couple<Boolean> validSides;
            BlockPos seatOf;
            if (entity instanceof Player || (seatOf = cc.getSeatOf(entity.m_142081_())) == null || (validSides = cc.conductorSeats.get(seatOf)) == null) continue;
            sides.setFirst((Boolean)sides.getFirst() != false || (Boolean)validSides.getFirst() != false);
            sides.setSecond((Boolean)sides.getSecond() != false || (Boolean)validSides.getSecond() != false);
        }
        return sides;
    }

    @Override
    public boolean startControlling(BlockPos controlsLocalPos, Player player) {
        if (player == null || player.m_5833_()) {
            return false;
        }
        if (this.carriage == null) {
            return false;
        }
        if (this.carriage.train.derailed) {
            return false;
        }
        Train train = this.carriage.train;
        if (train.runtime.getSchedule() != null && !train.runtime.paused) {
            train.status.manualControls();
        }
        train.navigation.cancelNavigation();
        train.runtime.paused = true;
        train.navigation.waitingForSignal = null;
        return true;
    }

    public Component m_5446_() {
        if (this.carriage == null) {
            return Lang.translateDirect("train", new Object[0]);
        }
        return this.carriage.train.name;
    }

    @Override
    public boolean control(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        boolean counteringAcceleration;
        if (this.carriage == null) {
            return false;
        }
        if (this.carriage.train.derailed) {
            return false;
        }
        if (this.f_19853_.f_46443_) {
            return true;
        }
        if (player.m_5833_()) {
            return false;
        }
        if (!this.toGlobalVector(VecHelper.getCenterOf((Vec3i)controlsLocalPos), 1.0f).m_82509_((Position)player.m_20182_(), 8.0)) {
            return false;
        }
        if (heldControls.contains(5)) {
            return false;
        }
        StructureTemplate.StructureBlockInfo info = this.contraption.getBlocks().get(controlsLocalPos);
        Direction initialOrientation = this.getInitialOrientation().m_122428_();
        boolean inverted = false;
        if (info != null && info.f_74676_.m_61138_((Property)ControlsBlock.f_54117_)) {
            boolean bl = inverted = !((Direction)info.f_74676_.m_61143_((Property)ControlsBlock.f_54117_)).equals((Object)initialOrientation);
        }
        if (this.hudPacketCooldown-- <= 0 && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> sp), (Object)new TrainHUDUpdatePacket(this.carriage.train));
            this.hudPacketCooldown = 5;
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        int targetSteer = 0;
        if (heldControls.contains(2)) {
            ++targetSteer;
        }
        if (heldControls.contains(3)) {
            --targetSteer;
        }
        if (inverted) {
            targetSpeed *= -1;
            targetSteer *= -1;
        }
        if (targetSpeed != 0) {
            this.carriage.train.burnFuel();
        }
        boolean slow = inverted ^ targetSpeed < 0;
        boolean spaceDown = heldControls.contains(4);
        GlobalStation currentStation = this.carriage.train.getCurrentStation();
        if (currentStation != null && spaceDown) {
            this.sendPrompt(player, Lang.translateDirect("train.arrived_at", Components.literal(currentStation.name).m_130938_(s -> s.m_178520_(7358000))), false);
            return true;
        }
        if (this.carriage.train.speedBeforeStall != null && targetSpeed != 0 && Math.signum(this.carriage.train.speedBeforeStall) != (double)Math.signum(targetSpeed)) {
            this.carriage.train.cancelStall();
        }
        if (currentStation != null && targetSpeed != 0) {
            this.stationMessage = false;
            this.sendPrompt(player, Lang.translateDirect("train.departing_from", Components.literal(currentStation.name).m_130938_(s -> s.m_178520_(7358000))), false);
        }
        if (currentStation == null) {
            double directedSpeed;
            Navigation nav = this.carriage.train.navigation;
            if (nav.destination != null) {
                if (!spaceDown) {
                    nav.cancelNavigation();
                }
                if (spaceDown) {
                    double f = nav.distanceToDestination / this.navDistanceTotal;
                    int progress = (int)(Mth.m_14008_((double)(1.0 - (1.0 - f) * (1.0 - f)), (double)0.0, (double)1.0) * 30.0);
                    boolean arrived = progress == 0;
                    MutableComponent whiteComponent = Components.literal(Strings.repeat((String)"|", (int)progress));
                    MutableComponent greenComponent = Components.literal(Strings.repeat((String)"|", (int)(30 - progress)));
                    int fromColor = 16761412;
                    int toColor = 5413141;
                    int mixedColor = Color.mixColors(toColor, fromColor, (float)progress / 30.0f);
                    int targetColor = arrived ? toColor : 0x544D45;
                    MutableComponent component = greenComponent.m_130938_(st -> st.m_178520_(mixedColor)).m_7220_((Component)whiteComponent.m_130938_(st -> st.m_178520_(targetColor)));
                    this.sendPrompt(player, component, true);
                    this.carriage.train.manualTick = true;
                    return true;
                }
            }
            double d = directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
            GlobalStation lookAhead = nav.findNearestApproachable(!this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted));
            if (lookAhead != null) {
                if (spaceDown) {
                    this.carriage.train.manualTick = true;
                    nav.startNavigation(nav.findPathTo(lookAhead, -1.0));
                    this.carriage.train.manualTick = false;
                    this.navDistanceTotal = nav.distanceToDestination;
                    return true;
                }
                this.displayApproachStationMessage(player, lookAhead);
            } else {
                this.cleanUpApproachStationMessage(player);
            }
        }
        this.carriage.train.manualSteer = targetSteer < 0 ? TravellingPoint.SteerDirection.RIGHT : (targetSteer > 0 ? TravellingPoint.SteerDirection.LEFT : TravellingPoint.SteerDirection.NONE);
        double topSpeed = this.carriage.train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF();
        double cappedTopSpeed = topSpeed * this.carriage.train.throttle;
        if (this.carriage.getLeadingPoint().edge != null && this.carriage.getLeadingPoint().edge.isTurn() || this.carriage.getTrailingPoint().edge != null && this.carriage.getTrailingPoint().edge.isTurn()) {
            topSpeed = this.carriage.train.maxTurnSpeed();
        }
        if (slow) {
            topSpeed /= 4.0;
        }
        this.carriage.train.targetSpeed = Math.min(topSpeed, cappedTopSpeed) * (double)targetSpeed;
        boolean bl = counteringAcceleration = Math.abs((double)Math.signum(targetSpeed) - Math.signum(this.carriage.train.speed)) > 1.5;
        if (slow && !counteringAcceleration) {
            this.carriage.train.backwardsDriver = player;
        }
        this.carriage.train.manualTick = true;
        this.carriage.train.approachTargetSpeed(counteringAcceleration ? 2.0f : 1.0f);
        return true;
    }

    private void sendPrompt(Player player, MutableComponent component, boolean shadow) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> sp), (Object)new TrainPromptPacket((Component)component, shadow));
        }
    }

    private void displayApproachStationMessage(Player player, GlobalStation station) {
        this.sendPrompt(player, Lang.translateDirect("contraption.controls.approach_station", Components.keybind("key.jump"), station.name), false);
        this.stationMessage = true;
    }

    private void cleanUpApproachStationMessage(Player player) {
        if (!this.stationMessage) {
            return;
        }
        player.m_5661_(Components.immutableEmpty(), true);
        this.stationMessage = false;
    }

    private void updateTrackGraph() {
        if (this.carriage == null) {
            return;
        }
        Optional optional = (Optional)this.f_19804_.m_135370_(TRACK_GRAPH);
        if (optional.isEmpty()) {
            this.carriage.train.graph = null;
            this.carriage.train.derailed = true;
            return;
        }
        TrackGraph graph = CreateClient.RAILWAYS.sided((LevelAccessor)this.f_19853_).trackNetworks.get(optional.get());
        if (graph == null) {
            return;
        }
        this.carriage.train.graph = graph;
        this.carriage.train.derailed = false;
    }

    public boolean m_142391_() {
        return false;
    }

    public Carriage getCarriage() {
        return this.carriage;
    }

    public void setCarriage(Carriage carriage) {
        this.carriage = carriage;
        this.trainId = carriage.train.id;
        this.carriageIndex = carriage.train.carriages.indexOf(carriage);
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            cc.swapStorageAfterAssembly(this);
        }
        if (carriage.train.graph != null) {
            this.f_19804_.m_135381_(TRACK_GRAPH, Optional.of(carriage.train.graph.id));
        }
        Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensional(this.f_19853_);
        dimensional.pivot = null;
        carriage.updateContraptionAnchors();
        dimensional.updateRenderedCutoff();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bindInstance(CarriageContraptionInstance instance) {
        this.instanceHolder = new WeakReference<CarriageContraptionInstance>(instance);
        this.updateRenderedPortalCutoff();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateRenderedPortalCutoff() {
        if (this.carriage == null) {
            return;
        }
        this.particleSlice.clear();
        this.particleAvgY = 0.0f;
        Contraption contraption = this.contraption;
        if (contraption instanceof CarriageContraption) {
            CarriageContraption cc = (CarriageContraption)contraption;
            Direction forward = cc.getAssemblyDirection().m_122427_();
            Direction.Axis axis = forward.m_122434_();
            boolean x = axis == Direction.Axis.X;
            boolean flip = true;
            for (BlockPos pos : this.contraption.getBlocks().keySet()) {
                if (!cc.atSeam(pos)) continue;
                int pX = x ? pos.m_123341_() : pos.m_123343_();
                pos = new BlockPos(pX *= forward.m_122421_().m_122540_() * (flip ? 1 : -1), pos.m_123342_(), 0);
                this.particleSlice.add(pos);
                this.particleAvgY += (float)pos.m_123342_();
            }
        }
        if (this.particleSlice.size() > 0) {
            this.particleAvgY /= (float)this.particleSlice.size();
        }
        if (this.instanceHolder == null) {
            return;
        }
        CarriageContraptionInstance instance = (CarriageContraptionInstance)((Object)this.instanceHolder.get());
        if (instance == null) {
            return;
        }
        int bogeySpacing = this.carriage.bogeySpacing;
        this.carriage.bogeys.forEachWithContext((bogey, first) -> {
            if (bogey == null) {
                return;
            }
            BlockPos bogeyPos = bogey.isLeading ? BlockPos.f_121853_ : BlockPos.f_121853_.m_5484_(this.getInitialOrientation().m_122428_(), bogeySpacing);
            instance.setBogeyVisibility((boolean)first, !this.contraption.isHiddenInPortal(bogeyPos));
        });
    }
}

