/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector4f;
import com.simibubi.create.foundation.outliner.Outline;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LineOutline
extends Outline {
    protected final Vector3d start = new Vector3d(0.0, 0.0, 0.0);
    protected final Vector3d end = new Vector3d(0.0, 0.0, 0.0);

    public LineOutline set(Vector3d start, Vector3d end) {
        this.start.m_176285_(start.f_86214_, start.f_86215_, start.f_86216_);
        this.end.m_176285_(end.f_86214_, end.f_86215_, end.f_86216_);
        return this;
    }

    public LineOutline set(Vec3 start, Vec3 end) {
        this.start.m_176285_(start.f_82479_, start.f_82480_, start.f_82481_);
        this.end.m_176285_(end.f_82479_, end.f_82480_, end.f_82481_);
        return this;
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        float width = this.params.getLineWidth();
        if (width == 0.0f) {
            return;
        }
        VertexConsumer consumer = buffer.m_6299_(RenderTypes.getOutlineSolid());
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = this.params.lightmap;
        boolean disableLineNormals = this.params.disableLineNormals;
        this.renderInner(ms, consumer, camera, pt, width, color, lightmap, disableLineNormals);
    }

    protected void renderInner(PoseStack ms, VertexConsumer consumer, Vec3 camera, float pt, float width, Vector4f color, int lightmap, boolean disableNormals) {
        this.bufferCuboidLine(ms, consumer, camera, this.start, this.end, width, color, lightmap, disableNormals);
    }

    public static class EndChasingLineOutline
    extends LineOutline {
        private float progress = 0.0f;
        private float prevProgress = 0.0f;
        private boolean lockStart;
        private final Vector3d startTemp = new Vector3d(0.0, 0.0, 0.0);

        public EndChasingLineOutline(boolean lockStart) {
            this.lockStart = lockStart;
        }

        public EndChasingLineOutline setProgress(float progress) {
            this.prevProgress = this.progress;
            this.progress = progress;
            return this;
        }

        @Override
        protected void renderInner(PoseStack ms, VertexConsumer consumer, Vec3 camera, float pt, float width, Vector4f color, int lightmap, boolean disableNormals) {
            Vector3d end;
            float distanceToTarget = Mth.m_14179_((float)pt, (float)this.prevProgress, (float)this.progress);
            if (this.lockStart) {
                end = this.start;
            } else {
                end = this.end;
                distanceToTarget = 1.0f - distanceToTarget;
            }
            Vector3d start = this.startTemp;
            double x = (this.start.f_86214_ - end.f_86214_) * (double)distanceToTarget + end.f_86214_;
            double y = (this.start.f_86215_ - end.f_86215_) * (double)distanceToTarget + end.f_86215_;
            double z = (this.start.f_86216_ - end.f_86216_) * (double)distanceToTarget + end.f_86216_;
            start.m_176285_((double)((float)x), (double)((float)y), (double)((float)z));
            this.bufferCuboidLine(ms, consumer, camera, start, end, width, color, lightmap, disableNormals);
        }
    }
}

