/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.ghost;

import com.jozufozu.flywheel.core.virtual.VirtualEmptyModelData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.ghost.GhostBlockParams;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IModelData;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, Vec3 var3, GhostBlockParams var4);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            ms.m_85836_();
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(params.state);
            RenderType layer = ItemBlockRenderTypes.m_109284_((BlockState)params.state, (boolean)false);
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.m_85837_((double)pos.m_123341_() - camera.f_82479_, (double)pos.m_123342_() - camera.f_82480_, (double)pos.m_123343_() - camera.f_82481_);
            dispatcher.m_110937_().renderModel(ms.m_85850_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, (IModelData)VirtualEmptyModelData.INSTANCE);
            ms.m_85849_();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            ms.m_85836_();
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher dispatcher = mc.m_91289_();
            BakedModel model = dispatcher.m_110910_(params.state);
            RenderType layer = RenderType.m_110466_();
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.m_85837_((double)pos.m_123341_() - camera.f_82479_, (double)pos.m_123342_() - camera.f_82480_, (double)pos.m_123343_() - camera.f_82481_);
            ms.m_85837_(0.5, 0.5, 0.5);
            ms.m_85841_(0.85f, 0.85f, 0.85f);
            ms.m_85837_(-0.5, -0.5, -0.5);
            float alpha = params.alphaSupplier.get().floatValue() * 0.75f * PlacementHelpers.getCurrentAlpha();
            this.renderModel(ms.m_85850_(), vb, params.state, model, 1.0f, 1.0f, 1.0f, alpha, LevelRenderer.m_109541_((BlockAndTintGetter)mc.f_91073_, (BlockPos)pos), OverlayTexture.f_118083_, (IModelData)VirtualEmptyModelData.INSTANCE);
            ms.m_85849_();
        }

        public void renderModel(PoseStack.Pose pose, VertexConsumer consumer, @Nullable BlockState state, BakedModel model, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, IModelData modelData) {
            Random random = new Random();
            for (Direction direction : Direction.values()) {
                random.setSeed(42L);
                TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, direction, random, modelData), packedLight, packedOverlay);
            }
            random.setSeed(42L);
            TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, null, random, modelData), packedLight, packedOverlay);
        }

        private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, float alpha, List<BakedQuad> quads, int packedLight, int packedOverlay) {
            for (BakedQuad quad : quads) {
                float f2;
                float f1;
                float f;
                if (quad.m_111304_()) {
                    f = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                    f1 = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                    f2 = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
                } else {
                    f = 1.0f;
                    f1 = 1.0f;
                    f2 = 1.0f;
                }
                consumer.putBulkData(pose, quad, f, f1, f2, alpha, packedLight, packedOverlay);
            }
        }
    }
}

