/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.recipe.conditions;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class HasFluidTagCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("createaddition", "has_fluid_tag");
    private final ResourceLocation tagName;

    public HasFluidTagCondition(String location) {
        this(new ResourceLocation(location));
    }

    public HasFluidTagCondition(String namespace, String path) {
        this(new ResourceLocation(namespace, path));
    }

    public HasFluidTagCondition(ResourceLocation tag) {
        this.tagName = tag;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public String toString() {
        return "has_fluid_tag(\"" + this.tagName + "\")";
    }

    public boolean test(ICondition.IContext context) {
        return !context.getTag(new TagKey(ForgeRegistries.Keys.FLUIDS, this.tagName)).m_6497_().isEmpty();
    }

    public boolean test() {
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<HasFluidTagCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, HasFluidTagCondition value) {
            json.addProperty("fluidTag", value.tagName.toString());
        }

        public HasFluidTagCondition read(JsonObject json) {
            return new HasFluidTagCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluidTag")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

