/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class Turbine {
    public final ForgeConfigSpec.IntValue maxTurbineHeight;
    public final ForgeConfigSpec.IntValue maxTurbineSize;
    public final ForgeConfigSpec.DoubleValue turbineAeroDragMultiplier;
    public final ForgeConfigSpec.DoubleValue turbineCoilDragMultiplier;
    public final ForgeConfigSpec.DoubleValue turbineFluidPerBladeMultiplier;
    public final ForgeConfigSpec.DoubleValue turbineMassDragMultiplier;
    public final ForgeConfigSpec.DoubleValue turbinePowerProductionMultiplier;

    Turbine(ForgeConfigSpec.Builder builder) {
        builder.comment("Define how Turbines works").push("turbine");
        this.maxTurbineHeight = builder.comment("The maximum valid height of a Turbine (Y axis), in blocks.").translation("config.bigreactors.turbine.maxturbineheight").worldRestart().defineInRange("maxTurbineHeight", 32, 5, 256);
        this.maxTurbineSize = builder.comment("The maximum valid size of a Turbine in the X/Z plane, in blocks.").translation("config.bigreactors.turbine.maxturbinesize").worldRestart().defineInRange("maxTurbineSize", 32, 5, 256);
        this.turbineAeroDragMultiplier = builder.comment(new String[]{"A multiplier for balancing rotor sizes.", "Multiplies the amount of energy lost to aerodynamic drag per tick."}).translation("config.bigreactors.turbine.turbineaerodragmultiplier").worldRestart().defineInRange("turbineAeroDragMultiplier", 1.0, 0.5, 10.0);
        this.turbineCoilDragMultiplier = builder.comment(new String[]{"A multiplier for balancing coil size.", "Multiplies the amount of energy drawn per coil block per tick."}).translation("config.bigreactors.turbine.turbinecoildragmultiplier").worldRestart().defineInRange("turbineCoilDragMultiplier", 1.0, 0.5, 10.0);
        this.turbineFluidPerBladeMultiplier = builder.comment(new String[]{"A multiplier for balancing coil size.", "Multiplies the amount of fluid each blade block can process (base of 25 will be multiplied,", "then rounded down to the nearest integer)."}).translation("config.bigreactors.turbine.turbinefluidperblademultiplier").worldRestart().defineInRange("turbineFluidPerBladeMultiplier", 1.0, 0.5, 10.0);
        this.turbineMassDragMultiplier = builder.comment(new String[]{"A multiplier for balancing rotor sizes.", "Multiplies the amount of energy lost to friction per tick."}).translation("config.bigreactors.turbine.turbinemassdragmultiplier").worldRestart().defineInRange("turbineMassDragMultiplier", 1.0, 0.5, 10.0);
        this.turbinePowerProductionMultiplier = builder.comment(new String[]{"A multiplier for balancing turbine power production.", "Stacks with powerProductionMultiplier."}).translation("config.bigreactors.turbine.turbinepowerproductionmultiplier").worldRestart().defineInRange("turbinePowerProductionMultiplier", 1.0, 0.5, 10.0);
        builder.pop();
    }
}

