/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.zerono.mods.extremereactors.api.radiation.RadiationPacket;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.radiation.EnergyConversion;
import it.zerono.mods.extremereactors.api.reactor.radiation.IrradiationData;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IHeat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IIrradiationSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorMachine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Stats;
import it.zerono.mods.zerocore.lib.data.nbt.IMergeableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergyBuffer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.profiling.ProfilerFiller;

public class ReactorLogic
implements ISyncableEntity,
IMergeableEntity {
    private static final float PASSIVE_COOLING_POWER_EFFICIENCY = 0.5f;
    private static final float PASSIVE_COOLING_TRANSFER_EFFICIENCY = 0.2f;
    private final IReactorMachine _reactor;
    private final EnergyBuffer _energyBuffer;
    private float _fertility;

    ReactorLogic(IReactorMachine reactor, EnergyBuffer energyBuffer) {
        this._reactor = reactor;
        this._energyBuffer = energyBuffer;
        this.setFertility(1.0f);
    }

    public float getFertility() {
        return this._fertility;
    }

    public boolean update() {
        ProfilerFiller profiler = this._reactor.getWorld().m_46473_();
        IHeat reactorHeat = this.getReactorHeat();
        if (Double.isNaN(reactorHeat.getAsDouble())) {
            reactorHeat.set(0.0);
        }
        double startingReactorHeat = reactorHeat.getAsDouble();
        double startingEnergy = this._energyBuffer.getEnergyStored();
        this.getUiStats().setAmountGeneratedLastTick(0.0);
        this.getUiStats().setFuelConsumedLastTick(0.0f);
        profiler.m_6180_("Irradiate");
        this.performIrradiation();
        profiler.m_6182_("Decay");
        this.performRadiationDecay(this._reactor.isMachineActive());
        profiler.m_6182_("Refueling");
        boolean reactantsChanged = this._reactor.performRefuelingCycle();
        reactantsChanged |= this._reactor.performInputCycle();
        profiler.m_6182_("Heat");
        this.transferHeatBetweenFuelAndReactor();
        this.transferHeatBetweenReactorAndCoolant();
        this.performPassiveHeatLoss();
        reactorHeat.resetIfNegative();
        this.getFuelHeat().resetIfNegative();
        profiler.m_6182_("Distribute");
        this._reactor.performOutputCycle();
        profiler.m_7238_();
        return reactantsChanged || startingReactorHeat != reactorHeat.getAsDouble() || startingEnergy != this._energyBuffer.getEnergyStored();
    }

    void reset() {
        this.setFertility(1.0f);
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        this.setFertility(data.m_128457_("fertility"));
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        data.m_128350_("fertility", this._fertility);
        return data;
    }

    public void syncDataFrom(IMergeableEntity other) {
        if (other instanceof ReactorLogic) {
            this._fertility = Math.max(this._fertility, ((ReactorLogic)other)._fertility);
        }
    }

    private IHeat getFuelHeat() {
        return this._reactor.getFuelHeat();
    }

    private IHeat getReactorHeat() {
        return this._reactor.getEnvironment().getReactorHeat();
    }

    private IFluidContainer getFluidContainer() {
        return this._reactor.getFluidContainer();
    }

    private IFuelContainer getFuelContainer() {
        return this._reactor.getFuelContainer();
    }

    private int getReactorVolume() {
        return this._reactor.getEnvironment().getReactorVolume();
    }

    private Stats getUiStats() {
        return this._reactor.getUiStats();
    }

    private int getFuelRodsCount() {
        return this._reactor.getEnvironment().getPartsCount(ReactorPartType.FuelRod);
    }

    private int getControlRodsCount() {
        return this._reactor.getEnvironment().getPartsCount(ReactorPartType.ControlRod);
    }

    private void performIrradiation() {
        if (!this._reactor.isMachineActive()) {
            return;
        }
        this._reactor.getEnvironment().getNextIrradiationSource().filter(IIrradiationSource::isLinked).ifPresent(this::performIrradiationFrom);
    }

    private void performIrradiationFrom(IIrradiationSource source) {
        this.radiate(this.getFuelContainer(), source, this.getFuelHeat().getAsDouble(), this.getControlRodsCount()).ifPresent(data -> {
            this.getFuelHeat().add(data.getFuelHeatChange(this.getFuelRodsCount()));
            this.getReactorHeat().add(data.getEnvironmentHeatChange(this.getReactorVolume()));
            this.getUiStats().changeFuelConsumedLastTick(data.fuelUsage);
        });
    }

    private void transferHeatBetweenFuelAndReactor() {
        double temperatureDifferential = this._reactor.getFuelHeat().getAsDouble() - this.getReactorHeat().getAsDouble();
        if (temperatureDifferential > 0.01) {
            double energyTransferred = temperatureDifferential * (double)this._reactor.getEnvironment().getFuelToReactorHeatTransferCoefficient();
            double fuelVolEnergy = EnergyConversion.getEnergyFromVolumeAndTemperature(this.getFuelRodsCount(), this.getFuelHeat().getAsDouble()) - energyTransferred;
            double reactorEnergy = EnergyConversion.getEnergyFromVolumeAndTemperature(this.getReactorVolume(), this.getReactorHeat().getAsDouble()) + energyTransferred;
            this.getFuelHeat().set(EnergyConversion.getTemperatureFromVolumeAndEnergy(this.getFuelRodsCount(), fuelVolEnergy));
            this.getReactorHeat().set(EnergyConversion.getTemperatureFromVolumeAndEnergy(this.getReactorVolume(), reactorEnergy));
        }
    }

    private void transferHeatBetweenReactorAndCoolant() {
        double temperatureDifferential = this.getReactorHeat().getAsDouble() - this.getCoolantTemperature();
        if (temperatureDifferential > (double)0.01f) {
            double energyTransferred = temperatureDifferential * (double)this._reactor.getEnvironment().getReactorToCoolantSystemHeatTransferCoefficient();
            double reactorEnergy = EnergyConversion.getEnergyFromVolumeAndTemperature(this.getReactorVolume(), this.getReactorHeat().getAsDouble());
            if (this._reactor.getOperationalMode().isPassive()) {
                this.generateEnergy((energyTransferred *= (double)0.2f) * 0.5);
            } else {
                energyTransferred -= this.getFluidContainer().onAbsorbHeat(energyTransferred, this._reactor.getVariant());
                this.getUiStats().setAmountGeneratedLastTick(this.getFluidContainer().getLiquidVaporizedLastTick());
            }
            this.getReactorHeat().set(EnergyConversion.getTemperatureFromVolumeAndEnergy(this.getReactorVolume(), reactorEnergy -= energyTransferred));
        }
    }

    private void performPassiveHeatLoss() {
        double temperatureDifferential = this.getReactorHeat().getAsDouble() - this.getPassiveCoolantTemperature();
        if (temperatureDifferential > (double)1.0E-6f) {
            double energyLost = Math.max(1.0, temperatureDifferential * (double)this._reactor.getEnvironment().getReactorHeatLossCoefficient());
            double reactorNewEnergy = Math.max(0.0, EnergyConversion.getEnergyFromVolumeAndTemperature(this.getReactorVolume(), this.getReactorHeat().getAsDouble()) - energyLost);
            this.getReactorHeat().set(EnergyConversion.getTemperatureFromVolumeAndEnergy(this.getReactorVolume(), reactorNewEnergy));
        }
    }

    private void generateEnergy(double rawEnergy) {
        rawEnergy = rawEnergy * (Double)Config.COMMON.general.powerProductionMultiplier.get() * (Double)Config.COMMON.reactor.reactorPowerProductionMultiplier.get() * (double)this._reactor.getVariant().getEnergyGenerationEfficiency();
        this._energyBuffer.modifyEnergyStored(rawEnergy);
        this.getUiStats().changeAmountGeneratedLastTick(rawEnergy);
    }

    private Optional<IrradiationData> radiate(IFuelContainer fuelContainer, IIrradiationSource source, double fuelHeat, int numControlRods) {
        if (fuelContainer.getFuelAmount() <= 0) {
            return Optional.empty();
        }
        FuelProperties fuelProperties = fuelContainer.getFuelProperties();
        double radiationPenaltyBase = Math.exp(-15.0 * Math.exp(-0.0025 * fuelHeat));
        int baseFuelAmount = fuelContainer.getFuelAmount() + fuelContainer.getWasteAmount() / 100;
        float fuelReactivity = fuelContainer.getFuelReactivity();
        float rawRadIntensity = (float)baseFuelAmount * fuelProperties.getFissionEventsPerFuelUnit();
        float scaledRadIntensity = (float)Math.pow(rawRadIntensity, fuelReactivity);
        scaledRadIntensity = (float)Math.pow(scaledRadIntensity / (float)numControlRods, fuelReactivity) * (float)numControlRods;
        float controlRodModifier = (float)(100 - source.getControlRodInsertionRatio()) / 100.0f;
        float effectiveRadIntensity = (scaledRadIntensity *= controlRodModifier) * (1.0f + (float)((double)-0.95f * Math.exp(-10.0 * Math.exp((double)-0.0012f * fuelHeat))));
        float radHardness = 0.2f + (float)(0.8 * radiationPenaltyBase);
        float rawFuelUsage = fuelProperties.getFuelUnitsPerFissionEvent() * (rawRadIntensity *= controlRodModifier) / this.getFertilityModifier() * ((Double)Config.COMMON.general.fuelUsageMultiplier.get()).floatValue();
        IrradiationData data = new IrradiationData();
        data.environmentEnergyAbsorption = 0.0;
        data.fuelAbsorbedRadiation = 0.0f;
        data.fuelEnergyAbsorption = 10.0f * effectiveRadIntensity;
        BlockPos originCoord = source.getWorldPosition();
        RadiationPacket radPacket = new RadiationPacket();
        effectiveRadIntensity *= 0.25f;
        for (Direction dir : source.getIrradiationDirections()) {
            radPacket.hardness = radHardness;
            radPacket.intensity = effectiveRadIntensity;
            BlockPos.MutableBlockPos currentCoord = originCoord.m_122032_();
            for (int ttl = 4; ttl > 0 && radPacket.intensity > 1.0E-4f; --ttl) {
                currentCoord.m_122173_(dir);
                this._reactor.getEnvironment().getModerator((BlockPos)currentCoord).moderateRadiation(data, radPacket);
            }
        }
        this._fertility += data.fuelAbsorbedRadiation;
        data.fuelAbsorbedRadiation = 0.0f;
        fuelContainer.onIrradiation(rawFuelUsage);
        data.fuelUsage = rawFuelUsage;
        return Optional.of(data);
    }

    private void performRadiationDecay(boolean isReactorActive) {
        float denominator = 20.0f;
        if (!isReactorActive) {
            denominator *= 200.0f;
        }
        this._fertility = Math.max(0.0f, this._fertility - Math.max(0.1f, this._fertility / denominator));
    }

    private float getFertilityModifier() {
        if (this._fertility <= 1.0f) {
            return 1.0f;
        }
        return (float)(Math.log10(this._fertility) + 1.0);
    }

    private void setFertility(float newFertility) {
        this._fertility = Float.isNaN(newFertility) || Float.isInfinite(newFertility) ? 1.0f : Math.max(newFertility, 0.0f);
    }

    private double getPassiveCoolantTemperature() {
        return 20.0;
    }

    private double getCoolantTemperature() {
        if (this._reactor.getOperationalMode().isPassive()) {
            return this.getPassiveCoolantTemperature();
        }
        return this.getFluidContainer().getLiquidTemperature(this.getReactorHeat().getAsDouble());
    }
}

