/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.util.TFStats;

public abstract class CritterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final VoxelShape DOWN_BB = Shapes.m_83064_((AABB)new AABB((double)0.2f, (double)0.85f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f));
    private final VoxelShape UP_BB = Shapes.m_83064_((AABB)new AABB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.15f, (double)0.8f));
    private final VoxelShape NORTH_BB = Shapes.m_83064_((AABB)new AABB((double)0.2f, (double)0.2f, (double)0.85f, (double)0.8f, (double)0.8f, 1.0));
    private final VoxelShape SOUTH_BB = Shapes.m_83064_((AABB)new AABB((double)0.2f, (double)0.2f, 0.0, (double)0.8f, (double)0.8f, (double)0.15f));
    private final VoxelShape WEST_BB = Shapes.m_83064_((AABB)new AABB((double)0.85f, (double)0.2f, (double)0.2f, 1.0, (double)0.8f, (double)0.8f));
    private final VoxelShape EAST_BB = Shapes.m_83064_((AABB)new AABB(0.0, (double)0.2f, (double)0.2f, (double)0.15f, (double)0.8f, (double)0.8f));

    protected CritterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.DOWN -> this.DOWN_BB;
            default -> this.UP_BB;
            case Direction.NORTH -> this.NORTH_BB;
            case Direction.SOUTH -> this.SOUTH_BB;
            case Direction.WEST -> this.WEST_BB;
            case Direction.EAST -> this.EAST_BB;
        };
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clicked = context.m_43719_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clicked)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        if (this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_())) {
            return state;
        }
        for (Direction dir : context.m_6232_()) {
            state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir.m_122424_());
            if (!this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return state;
        }
        return null;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (((Direction)state.m_61143_((Property)FACING)).m_122424_() == direction && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
        BlockPos restingPos = pos.m_142300_(facing.m_122424_());
        return CritterBlock.m_49863_((LevelReader)level, (BlockPos)restingPos, (Direction)facing);
    }

    public abstract ItemStack getSquishResult();

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42590_) {
            if (this == TFBlocks.FIREFLY.get()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_150109_().m_36054_(new ItemStack((ItemLike)TFBlocks.FIREFLY_JAR.get()));
                level.m_46597_(pos, (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
                return InteractionResult.SUCCESS;
            }
            if (this == TFBlocks.CICADA.get()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                player.m_150109_().m_36054_(new ItemStack((ItemLike)TFBlocks.CICADA_JAR.get()));
                if (level.m_5776_()) {
                    Minecraft.m_91087_().m_91106_().m_120386_(TFSounds.CICADA.m_11660_(), SoundSource.NEUTRAL);
                }
                level.m_46597_(pos, (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Projectile && !entity.m_6095_().m_204039_(EntityTagGenerator.DONT_KILL_BUGS) || entity instanceof FallingBlockEntity) {
            Projectile projectile;
            Entity entity2;
            level.m_46597_(pos, (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
            if (level.m_5776_()) {
                Minecraft.m_91087_().m_91106_().m_120386_(TFSounds.CICADA.m_11660_(), SoundSource.NEUTRAL);
            }
            level.m_5594_(null, pos, TFSounds.BUG_SQUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity squish = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), this.getSquishResult());
            squish.m_19983_(squish.m_32055_());
            for (int i = 0; i < 50; ++i) {
                boolean wallBug = state.m_61143_((Property)FACING) != Direction.UP;
                level.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()), true, (double)((float)pos.m_123341_() + Mth.m_14068_((Random)level.m_5822_(), (float)0.25f, (float)0.75f)), (double)((float)pos.m_123342_() + (wallBug ? 0.5f : 0.0f)), (double)((float)pos.m_123343_() + Mth.m_14068_((Random)level.m_5822_(), (float)0.25f, (float)0.75f)), 0.0, 0.0, 0.0);
            }
            if (entity instanceof Projectile && (entity2 = (projectile = (Projectile)entity).m_37282_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                player.m_36220_((ResourceLocation)TFStats.BUGS_SQUISHED.get());
                TFAdvancements.KILL_BUG.trigger(player, state);
            }
        }
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, getter, tooltip, flag);
        if (ModList.get().isLoaded("undergarden")) {
            tooltip.add((Component)new TranslatableComponent("tooltip.pebble").m_130940_(ChatFormatting.GRAY));
        }
    }
}

