/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.math.Vector3f;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.block.LockedVanishingBlock;
import twilightforest.block.TFBlocks;

public class VanishingBlock
extends Block {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty VANISHED = BooleanProperty.m_61465_((String)"vanished");
    private static final VoxelShape VANISHED_SHAPE = VanishingBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public VanishingBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
    }

    private boolean isVanished(BlockState state) {
        return state.m_61138_((Property)VANISHED) && (Boolean)state.m_61143_((Property)VANISHED) != false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.isVanished(state) ? VANISHED_SHAPE : super.m_5940_(state, world, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return this.isVanished(state) ? Shapes.m_83040_() : super.m_5939_(state, world, pos, ctx);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!this.isVanished(state) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (VanishingBlock.areBlocksLocked((BlockGetter)world, pos)) {
                world.m_5594_(null, pos, TFSounds.LOCKED_VANISHING_BLOCK, SoundSource.BLOCKS, 1.0f, 0.3f);
            } else {
                this.activate(world, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)ACTIVE) == false ? 6000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() ? !VanishingBlock.areBlocksLocked(world, pos) : super.canEntityDestroy(state, world, pos, entity);
    }

    private static boolean areBlocksLocked(BlockGetter world, BlockPos start) {
        int limit = 512;
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        queue.offer(start);
        for (int iter = 0; !queue.isEmpty() && iter < limit; ++iter) {
            BlockPos cur = (BlockPos)queue.pop();
            BlockState state = world.m_8055_(cur);
            if (state.m_60734_() == TFBlocks.LOCKED_VANISHING_BLOCK.get() && ((Boolean)state.m_61143_((Property)LockedVanishingBlock.LOCKED)).booleanValue()) {
                return true;
            }
            checked.add(cur);
            if (!(state.m_60734_() instanceof VanishingBlock)) continue;
            for (Direction facing : Direction.values()) {
                BlockPos neighbor = cur.m_142300_(facing);
                if (checked.contains(neighbor)) continue;
                queue.offer(neighbor);
            }
        }
        return false;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        if (!this.isVanished(state) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && world.m_46753_(pos) && !VanishingBlock.areBlocksLocked((BlockGetter)world, pos)) {
            this.activate(world, pos);
        }
    }

    @Deprecated
    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (world.f_46443_) {
            return;
        }
        if (this.isVanished(state)) {
            if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                world.m_186460_(pos, (Block)this, 15);
            }
            world.m_5594_(null, pos, TFSounds.REAPPEAR_BLOCK, SoundSource.BLOCKS, 0.3f, 0.6f);
        } else if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (state.m_61138_((Property)VANISHED)) {
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VANISHED, (Comparable)Boolean.valueOf(true)));
                world.m_186460_(pos, (Block)this, 80);
            } else {
                world.m_7471_(pos, false);
            }
            world.m_5594_(null, pos, state.m_60734_() == TFBlocks.REAPPEARING_BLOCK.get() ? TFSounds.REAPPEAR_POOF : TFSounds.VANISHING_BLOCK, SoundSource.BLOCKS, 0.3f, 0.5f);
            for (Direction e : Direction.values()) {
                this.activate((Level)world, pos.m_142300_(e));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            this.sparkle(world, pos);
        }
    }

    public void sparkle(Level worldIn, BlockPos pos) {
        Random random = worldIn.f_46441_;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.m_123341_() + random.nextFloat();
            double d2 = (float)pos.m_123342_() + random.nextFloat();
            double d3 = (float)pos.m_123343_() + random.nextFloat();
            if (i == 0 && !worldIn.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)worldIn, pos)) {
                d2 = (double)pos.m_123342_() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)worldIn, pos)) {
                d2 = (double)pos.m_123342_() - d0;
            }
            if (i == 2 && !worldIn.m_8055_(pos.m_142128_()).m_60804_((BlockGetter)worldIn, pos)) {
                d3 = (double)pos.m_123343_() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.m_8055_(pos.m_142127_()).m_60804_((BlockGetter)worldIn, pos)) {
                d3 = (double)pos.m_123343_() - d0;
            }
            if (i == 4 && !worldIn.m_8055_(pos.m_142126_()).m_60804_((BlockGetter)worldIn, pos)) {
                d1 = (double)pos.m_123341_() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.m_8055_(pos.m_142125_()).m_60804_((BlockGetter)worldIn, pos)) {
                d1 = (double)pos.m_123341_() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.m_123341_() || d1 > (double)(pos.m_123341_() + 1) || d2 < 0.0 || d2 > (double)(pos.m_123342_() + 1) || d3 < (double)pos.m_123343_()) && !(d3 > (double)(pos.m_123343_() + 1))) continue;
            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(f1, f2, f3), 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    private void activate(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof VanishingBlock && !this.isVanished(state) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.m_186460_(pos, state.m_60734_(), 2 + world.f_46441_.nextInt(5));
        }
    }
}

