/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraPart;

public class HydraHeadModel
extends ListModel<HydraHead> {
    public ModelPart head;
    public ModelPart mouth;

    public HydraHeadModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.mouth = this.head.m_171324_("mouth");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition head = partRoot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(260, 64).m_171481_(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).m_171514_(236, 128).m_171481_(-16.0f, -2.0f, -40.0f, 32.0f, 10.0f, 24.0f).m_171514_(356, 70).m_171481_(-12.0f, 8.0f, -36.0f, 24.0f, 6.0f, 20.0f), PartPose.f_171404_);
        head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(240, 162).m_171481_(-15.0f, 0.0f, -24.0f, 30.0f, 8.0f, 24.0f), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-14.0f));
        head.m_171599_("plate", CubeListBuilder.m_171558_().m_171514_(388, 0).m_171481_(-24.0f, -48.0f, 0.0f, 48.0f, 48.0f, 6.0f).m_171514_(220, 0).m_171481_(-4.0f, -32.0f, -8.0f, 8.0f, 32.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)512, (int)256);
    }

    public void setupAnim(HydraHead entity, float v, float v1, float v2, float v3, float v4) {
    }

    public void prepareMobModel(HydraHead entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.head.f_104204_ = this.getRotationY(entity, partialTicks);
        this.head.f_104203_ = this.getRotationX(entity, partialTicks);
        float mouthOpenLast = entity.getMouthOpenLast();
        float mouthOpenReal = entity.getMouthOpen();
        float mouthOpen = Mth.m_14179_((float)partialTicks, (float)mouthOpenLast, (float)mouthOpenReal);
        this.head.f_104203_ -= (float)((double)mouthOpen * 0.2617993877991494);
        this.mouth.f_104203_ = (float)((double)mouthOpen * 1.0471975511965976);
    }

    public float getRotationY(HydraPart whichHead, float time) {
        float yaw = whichHead.f_19859_ + (whichHead.m_146908_() - whichHead.f_19859_) * time;
        return yaw / 57.29578f;
    }

    public float getRotationX(HydraPart whichHead, float time) {
        return (whichHead.f_19860_ + (whichHead.m_146909_() - whichHead.f_19860_) * time) / 57.29578f;
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head);
    }
}

