/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import twilightforest.client.model.entity.UpperGoblinKnightModel;
import twilightforest.client.renderer.entity.TFBipedRenderer;
import twilightforest.entity.monster.UpperGoblinKnight;

public class UpperGoblinKnightRenderer
extends TFBipedRenderer<UpperGoblinKnight, UpperGoblinKnightModel> {
    public UpperGoblinKnightRenderer(EntityRendererProvider.Context manager, UpperGoblinKnightModel model, float shadowSize) {
        super(manager, model, shadowSize, "doublegoblin.png");
    }

    protected void setupRotations(UpperGoblinKnight upperKnight, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)upperKnight, stack, ageInTicks, rotationYaw, partialTicks);
        if (upperKnight.heavySpearTimer > 0) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(this.getPitchForAttack((float)(60 - upperKnight.heavySpearTimer) + partialTicks)));
        }
    }

    private float getPitchForAttack(float attackTime) {
        if (attackTime <= 10.0f) {
            return attackTime * 3.0f;
        }
        if (attackTime > 10.0f && attackTime <= 30.0f) {
            return 30.0f;
        }
        if (attackTime > 30.0f && attackTime <= 33.0f) {
            return (attackTime - 30.0f) * -25.0f + 30.0f;
        }
        if (attackTime > 33.0f && attackTime <= 50.0f) {
            return -45.0f;
        }
        if (attackTime > 50.0f && attackTime <= 60.0f) {
            return (10.0f - (attackTime - 50.0f)) * -4.5f;
        }
        return 0.0f;
    }
}

