/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.loading.FMLEnvironment;
import twilightforest.item.MagicMapItem;

public class MapBiomesCommand {
    private static final DecimalFormat numberFormat = new DecimalFormat("#.00");
    private static final HashMap<Biome, Color> BIOME2COLOR = new HashMap();

    private static void init() {
        if (!BIOME2COLOR.isEmpty()) {
            return;
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"biomepng").requires(cs -> cs.m_6761_(2))).executes(MapBiomesCommand::execute);
    }

    private static int execute(CommandContext<CommandSourceStack> source) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return -1;
        }
        MapBiomesCommand.init();
        HashMap<Biome, Integer> biomeCount = new HashMap<Biome, Integer>();
        BufferedImage img = new BufferedImage(4096, 4096, 1);
        int progressUpdate = img.getHeight() / 8;
        for (int x = 0; x < img.getHeight(); ++x) {
            for (int z = 0; z < img.getWidth(); ++z) {
                Biome b = (Biome)((CommandSourceStack)source.getSource()).m_81372_().m_203495_(x - 2048, 0, z - 2048).m_203334_();
                Color color = BIOME2COLOR.get(b);
                if (color == null) {
                    int colorInt = MagicMapItem.getBiomeColor(b);
                    if (colorInt == 0) {
                        colorInt = b.m_47464_(0.0, 0.0);
                    }
                    color = new Color(colorInt | 0xFF000000);
                    BIOME2COLOR.put(b, color);
                }
                if (!biomeCount.containsKey(b)) {
                    biomeCount.put(b, 0);
                } else {
                    biomeCount.put(b, (Integer)biomeCount.get(b) + 1);
                }
                img.setRGB(x, z, color.getRGB());
            }
            if (x % progressUpdate != 0) continue;
            ((CommandSourceStack)source.getSource()).m_81354_((Component)new TranslatableComponent((double)x / (double)img.getHeight() * 100.0 + "% Done mapping"), true);
        }
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Approximate biome-block counts within an 2048x2048 region"), true);
        int totalCount = biomeCount.values().stream().mapToInt(i -> i).sum();
        biomeCount.forEach((biome, integer) -> ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent(biome.toString()).m_130946_(": " + integer + ChatFormatting.GRAY + " (" + numberFormat.format((double)integer.intValue() / (double)totalCount * 100.0) + "%)"), true));
        Path p = Paths.get("biomemap.png", new String[0]);
        try {
            ImageIO.write((RenderedImage)img, "png", p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        ((CommandSourceStack)source.getSource()).m_81354_((Component)new TextComponent("Image saved!"), true);
        return 1;
    }
}

