/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import twilightforest.TFSounds;
import twilightforest.entity.boss.Lich;
import twilightforest.entity.monster.LichMinion;
import twilightforest.item.LifedrainScepterItem;
import twilightforest.util.EntityUtil;

public class LichAbsorbMinionsGoal
extends Goal {
    private final Lich lich;

    public LichAbsorbMinionsGoal(Lich lich) {
        this.lich = lich;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.lich.m_21223_() < this.lich.m_21233_() / 2.0f && this.lich.countMyMinions() > 0;
    }

    public void m_8056_() {
        super.m_8056_();
        this.lich.setScepterTime();
    }

    public void m_8041_() {
        super.m_8041_();
        this.lich.resetScepterTime();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.lich.getScepterTimeLeft() > 0) {
            return;
        }
        List minions = this.lich.m_183503_().m_45976_(LichMinion.class, this.lich.m_142469_().m_82377_(32.0, 16.0, 32.0)).stream().filter(m -> m.master == this.lich).collect(Collectors.toList());
        if (!minions.isEmpty()) {
            LichMinion minion = (LichMinion)((Object)minions.get(0));
            minion.m_146870_();
            LifedrainScepterItem.animateTargetShatter((ServerLevel)this.lich.m_183503_(), (LivingEntity)minion);
            this.lich.m_183503_().m_5594_(null, minion.m_142538_(), EntityUtil.getDeathSound((LivingEntity)minion), SoundSource.HOSTILE, 1.0f, minion.m_6100_());
            this.lich.m_5496_(TFSounds.LICH_POP_MOB, 3.0f, 0.4f + this.lich.m_21187_().nextFloat() * 0.2f);
            minion.m_5496_(TFSounds.LICH_POP_MOB, 3.0f, 0.4f + this.lich.m_21187_().nextFloat() * 0.2f);
            this.lich.makeMagicTrail(minion.m_146901_(), this.lich.m_146901_(), 0.5f, 0.0f, 1.0f);
            this.lich.m_5634_(minion.m_21223_());
            this.lich.m_6674_(InteractionHand.MAIN_HAND);
            this.lich.setPopCooldown(40);
        }
    }
}

