/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.TFSounds;

public class HostileWolf
extends Monster {
    public HostileWolf(EntityType<? extends HostileWolf> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HostileWolf.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static boolean getCanSpawnHere(EntityType<? extends HostileWolf> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, Random pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (Random)pRandom) && HostileWolf.m_21400_(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (Random)pRandom);
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        if (entity != null && entity != this.m_5448_()) {
            this.m_5496_(this.getTargetSound(), 4.0f, this.m_6100_());
        }
        super.m_6710_(entity);
    }

    protected SoundEvent getTargetSound() {
        return TFSounds.HOSTILE_WOLF_TARGET;
    }

    protected SoundEvent m_7515_() {
        return TFSounds.HOSTILE_WOLF_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return TFSounds.HOSTILE_WOLF_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.HOSTILE_WOLF_DEATH;
    }

    protected void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected boolean m_8028_() {
        return true;
    }

    public float getTailAngle() {
        if (this.m_5448_() != null) {
            return 1.5393804f;
        }
        return 0.62831855f;
    }

    public static class LeapGoal
    extends LeapAtTargetGoal {
        private final Mob mob;

        public LeapGoal(Mob mob, float jump) {
            super(mob, jump);
            this.mob = mob;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
        }
    }
}

