/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.Yeti;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.potions.TFMobEffects;
import twilightforest.util.TFDamageSources;

public class IceBomb
extends TFThrowable {
    private int zoneTimer = 80;
    private boolean hasHit;

    public IceBomb(EntityType<? extends IceBomb> type, Level world) {
        super(type, world);
    }

    public IceBomb(EntityType<? extends IceBomb> type, Level world, LivingEntity thrower) {
        super(type, world, thrower);
    }

    public IceBomb(Level world, Position pos) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.THROWN_ICE.get()), world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    protected void m_6532_(HitResult ray) {
        this.m_20334_(0.0, 0.0, 0.0);
        this.hasHit = true;
        this.doTerrainEffects();
    }

    private void doTerrainEffects() {
        int range = 3;
        int ix = Mth.m_14107_((double)this.f_19790_);
        int iy = Mth.m_14107_((double)this.f_19791_);
        int iz = Mth.m_14107_((double)this.f_19792_);
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = new BlockPos(ix + x, iy + y, iz + z);
                    this.doTerrainEffect(pos);
                }
            }
        }
    }

    private void doTerrainEffect(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (!this.f_19853_.f_46443_) {
            if (state.m_60767_() == Material.f_76305_) {
                this.f_19853_.m_46597_(pos, Blocks.f_50126_.m_49966_());
            }
            if (state == Blocks.f_49991_.m_49966_()) {
                this.f_19853_.m_46597_(pos, Blocks.f_50080_.m_49966_());
            }
            if (this.f_19853_.m_46859_(pos) && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)this.f_19853_, pos)) {
                this.f_19853_.m_46597_(pos, Blocks.f_50125_.m_49966_());
            }
            if (state.m_204336_(BlockTagGenerator.ICE_BOMB_REPLACEABLES)) {
                this.f_19853_.m_7731_(pos, Blocks.f_50125_.m_49966_().m_60710_((LevelReader)this.f_19853_, pos) ? Blocks.f_50125_.m_49966_() : Blocks.f_50016_.m_49966_(), 3);
            }
            if (state.m_60713_(Blocks.f_50125_) && (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) < 8) {
                this.f_19853_.m_46597_(pos, (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) + 1)));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasHit) {
            this.m_20184_().m_82542_(0.1, 0.1, 0.1);
            --this.zoneTimer;
            this.makeIceZone();
            if (!this.f_19853_.f_46443_ && this.zoneTimer <= 0) {
                this.f_19853_.m_46796_(2001, new BlockPos((Vec3i)this.m_142538_()), Block.m_49956_((BlockState)Blocks.f_50126_.m_49966_()));
                this.m_146870_();
            }
        } else {
            this.makeTrail();
        }
    }

    public void makeTrail() {
        BlockState stateId = Blocks.f_50125_.m_49966_();
        for (int i = 0; i < 5; ++i) {
            double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.nextFloat() - 0.5f));
            double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.nextFloat() - 0.5f));
            double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.nextFloat() - 0.5f));
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, stateId), dx, dy, dz, -this.m_20184_().m_7096_(), -this.m_20184_().m_7098_(), -this.m_20184_().m_7094_());
        }
    }

    private void makeIceZone() {
        if (this.f_19853_.f_46443_) {
            BlockState stateId = Blocks.f_50125_.m_49966_();
            for (int i = 0; i < 15; ++i) {
                double dx = this.m_20185_() + (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 3.0f);
                double dy = this.m_20186_() + (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 3.0f);
                double dz = this.m_20189_() + (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 3.0f);
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, stateId), dx, dy, dz, 0.0, 0.0, 0.0);
            }
        } else if (this.zoneTimer % 20 == 0) {
            this.hitNearbyEntities();
        }
    }

    private void hitNearbyEntities() {
        List nearby = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82377_(3.0, 2.0, 3.0));
        for (LivingEntity entity : nearby) {
            if (entity == this.m_37282_()) continue;
            if (entity instanceof Yeti) {
                BlockPos pos = new BlockPos(entity.f_19790_, entity.f_19791_, entity.f_19792_);
                this.f_19853_.m_46597_(pos, Blocks.f_50126_.m_49966_());
                this.f_19853_.m_46597_(pos.m_7494_(), Blocks.f_50126_.m_49966_());
                entity.m_146870_();
                continue;
            }
            if (!entity.m_6095_().m_204039_(EntityTypeTags.f_144294_)) continue;
            entity.m_6469_(TFDamageSources.frozen((Entity)this, (LivingEntity)this.m_37282_()), entity.m_6095_().m_204039_(EntityTypeTags.f_144295_) ? 5.0f : 1.0f);
            entity.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100));
        }
    }

    public BlockState getBlockState() {
        return Blocks.f_50354_.m_49966_();
    }

    protected float m_7139_() {
        return this.hasHit ? 0.0f : 0.025f;
    }
}

